/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.DetachWireCommand;
import org.fabric3.fabric.container.command.WireCommand;
import org.fabric3.spi.container.command.CompensatableCommand;

public class ConnectionCommand
implements CompensatableCommand {
    private static final long serialVersionUID = -2313380946362271104L;
    private URI componentUri;
    private List<AttachWireCommand> attachCommands = new ArrayList<AttachWireCommand>();
    private List<DetachWireCommand> detachCommands = new ArrayList<DetachWireCommand>();

    public ConnectionCommand(URI componentUri) {
        this();
        this.componentUri = componentUri;
    }

    protected ConnectionCommand() {
    }

    public ConnectionCommand getCompensatingCommand() {
        WireCommand compensatingWireCommand;
        WireCommand command;
        ListIterator<WireCommand> iter;
        ConnectionCommand compensating = new ConnectionCommand(this.componentUri);
        if (!this.attachCommands.isEmpty()) {
            iter = this.attachCommands.listIterator(this.attachCommands.size());
            while (iter.hasPrevious()) {
                command = iter.previous();
                compensatingWireCommand = ((AttachWireCommand)command).getCompensatingCommand();
                compensating.add((DetachWireCommand)compensatingWireCommand);
            }
        }
        if (!this.detachCommands.isEmpty()) {
            iter = this.detachCommands.listIterator(this.detachCommands.size());
            while (iter.hasPrevious()) {
                command = (DetachWireCommand)iter.previous();
                compensatingWireCommand = ((DetachWireCommand)command).getCompensatingCommand();
                compensating.add((AttachWireCommand)compensatingWireCommand);
            }
        }
        return compensating;
    }

    public URI getComponentUri() {
        return this.componentUri;
    }

    public List<AttachWireCommand> getAttachCommands() {
        return this.attachCommands;
    }

    public List<DetachWireCommand> getDetachCommands() {
        return this.detachCommands;
    }

    public void add(AttachWireCommand command) {
        this.attachCommands.add(command);
    }

    public void add(DetachWireCommand command) {
        this.detachCommands.add(command);
    }
}

