/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.command;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.fabric3.fabric.container.command.AttachChannelConnectionCommand;
import org.fabric3.fabric.container.command.BuildChannelCommand;
import org.fabric3.fabric.container.command.DetachChannelConnectionCommand;
import org.fabric3.fabric.container.command.DisposeChannelCommand;
import org.fabric3.spi.container.command.CompensatableCommand;

public class ChannelConnectionCommand
implements CompensatableCommand {
    private static final long serialVersionUID = 8746788639966402901L;
    private List<BuildChannelCommand> buildCommands;
    private List<DisposeChannelCommand> disposeCommands;
    private List<AttachChannelConnectionCommand> attachCommands = new ArrayList<AttachChannelConnectionCommand>();
    private List<DetachChannelConnectionCommand> detachCommands = new ArrayList<DetachChannelConnectionCommand>();

    public ChannelConnectionCommand() {
        this.buildCommands = new ArrayList<BuildChannelCommand>();
        this.disposeCommands = new ArrayList<DisposeChannelCommand>();
    }

    public ChannelConnectionCommand getCompensatingCommand() {
        Object compensatingCommand;
        ListIterator<Object> iterator;
        ChannelConnectionCommand compensating = new ChannelConnectionCommand();
        for (BuildChannelCommand buildChannelCommand : this.buildCommands) {
            compensating.addDisposeChannelCommand(buildChannelCommand.getCompensatingCommand());
        }
        for (DisposeChannelCommand disposeChannelCommand : this.disposeCommands) {
            compensating.addBuildChannelCommand(disposeChannelCommand.getCompensatingCommand());
        }
        if (!this.attachCommands.isEmpty()) {
            iterator = this.attachCommands.listIterator(this.attachCommands.size());
            while (iterator.hasPrevious()) {
                AttachChannelConnectionCommand attachChannelConnectionCommand = iterator.previous();
                compensatingCommand = attachChannelConnectionCommand.getCompensatingCommand();
                compensating.add((DetachChannelConnectionCommand)compensatingCommand);
            }
        }
        if (!this.detachCommands.isEmpty()) {
            iterator = this.detachCommands.listIterator(this.detachCommands.size());
            while (iterator.hasPrevious()) {
                DetachChannelConnectionCommand detachChannelConnectionCommand = (DetachChannelConnectionCommand)iterator.previous();
                compensatingCommand = detachChannelConnectionCommand.getCompensatingCommand();
                compensating.add((AttachChannelConnectionCommand)compensatingCommand);
            }
        }
        return compensating;
    }

    public List<BuildChannelCommand> getBuildChannelCommands() {
        return this.buildCommands;
    }

    public void addBuildChannelCommand(BuildChannelCommand command) {
        this.buildCommands.add(command);
    }

    public List<DisposeChannelCommand> getDisposeChannelCommands() {
        return this.disposeCommands;
    }

    public void addDisposeChannelCommand(DisposeChannelCommand command) {
        this.disposeCommands.add(command);
    }

    public List<AttachChannelConnectionCommand> getAttachCommands() {
        return this.attachCommands;
    }

    public void add(AttachChannelConnectionCommand command) {
        this.attachCommands.add(command);
    }

    public List<DetachChannelConnectionCommand> getDetachCommands() {
        return this.detachCommands;
    }

    public void add(DetachChannelConnectionCommand command) {
        this.detachCommands.add(command);
    }
}

