/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.channel;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.fabric3.fabric.container.channel.DuplicateChannelException;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.model.physical.ChannelSide;

public class ChannelManagerImpl
implements ChannelManager {
    private Map<URI, Holder> collocatedChannels = new ConcurrentHashMap<URI, Holder>();
    private Map<URI, Holder> producerChannels = new ConcurrentHashMap<URI, Holder>();
    private Map<URI, Holder> consumerChannels = new ConcurrentHashMap<URI, Holder>();

    public Channel getChannel(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        return holder != null ? holder.channel : null;
    }

    public Channel getAndIncrementChannel(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        if (holder == null) {
            return null;
        }
        holder.counter.incrementAndGet();
        return holder.channel;
    }

    public Channel getAndDecrementChannel(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        if (holder == null) {
            return null;
        }
        holder.counter.decrementAndGet();
        return holder.channel;
    }

    public int getCount(URI uri, ChannelSide channelSide) {
        this.checkUri(uri);
        Holder holder = this.getHolder(uri, channelSide);
        if (holder == null) {
            return -1;
        }
        return holder.counter.get();
    }

    public void register(Channel channel) throws DuplicateChannelException {
        ChannelSide channelSide = channel.getChannelSide();
        if (ChannelSide.COLLOCATED == channelSide) {
            this.checkAndPut(channel, this.collocatedChannels);
        } else if (ChannelSide.CONSUMER == channelSide) {
            this.checkAndPut(channel, this.consumerChannels);
        } else if (ChannelSide.PRODUCER == channelSide) {
            this.checkAndPut(channel, this.producerChannels);
        }
    }

    public Channel unregister(URI uri, ChannelSide channelSide) {
        Holder holder = null;
        switch (channelSide) {
            case CONSUMER: {
                holder = this.consumerChannels.remove(uri);
                break;
            }
            case PRODUCER: {
                holder = this.producerChannels.remove(uri);
                break;
            }
            case COLLOCATED: {
                holder = this.collocatedChannels.remove(uri);
            }
        }
        if (holder == null) {
            return null;
        }
        return holder.channel;
    }

    public void startContext(QName deployable) {
        this.doStart(deployable, this.collocatedChannels);
        this.doStart(deployable, this.consumerChannels);
        this.doStart(deployable, this.producerChannels);
    }

    public void stopContext(QName deployable) {
        this.doStop(deployable, this.producerChannels);
        this.doStop(deployable, this.consumerChannels);
        this.doStop(deployable, this.collocatedChannels);
    }

    private void checkUri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Channel URI was null");
        }
    }

    private Holder getHolder(URI uri, ChannelSide channelSide) {
        Holder holder;
        Holder holder2 = holder = ChannelSide.CONSUMER == channelSide ? this.consumerChannels.get(uri) : this.producerChannels.get(uri);
        if (holder == null) {
            holder = this.collocatedChannels.get(uri);
        }
        return holder;
    }

    private void checkAndPut(Channel channel, Map<URI, Holder> map) throws DuplicateChannelException {
        URI uri = channel.getUri();
        if (map.containsKey(uri)) {
            throw new DuplicateChannelException("Channel already exists: " + uri);
        }
        map.put(uri, new Holder(channel));
    }

    private void doStart(QName deployable, Map<URI, Holder> map) {
        for (Holder holder : map.values()) {
            if (!deployable.equals(holder.channel.getDeployable())) continue;
            holder.channel.start();
        }
    }

    private void doStop(QName deployable, Map<URI, Holder> map) {
        for (Holder holder : map.values()) {
            if (!deployable.equals(holder.channel.getDeployable())) continue;
            holder.channel.stop();
        }
    }

    private class Holder {
        private Channel channel;
        private AtomicInteger counter = new AtomicInteger(1);

        private Holder(Channel channel) {
            this.channel = channel;
        }
    }
}

