/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder.classloader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.fabric.container.builder.classloader.ClassLoaderBuilder;
import org.fabric3.fabric.container.builder.classloader.ClassLoaderBuilderException;
import org.fabric3.fabric.container.builder.classloader.ClassLoaderBuilderMonitor;
import org.fabric3.fabric.container.builder.classloader.ClassLoaderTracker;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.container.builder.classloader.ClassLoaderListener;
import org.fabric3.spi.container.builder.classloader.ClassLoaderWireBuilder;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResolutionException;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.fabric3.spi.model.physical.PhysicalClassLoaderDefinition;
import org.fabric3.spi.model.physical.PhysicalClassLoaderWireDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ClassLoaderBuilderImpl
implements ClassLoaderBuilder {
    private ClassLoaderWireBuilder wireBuilder;
    private ClassLoaderRegistry classLoaderRegistry;
    private ClasspathProcessorRegistry classpathProcessorRegistry;
    private ContributionResolver resolver;
    private ClassLoaderTracker tracker;
    private List<ClassLoaderListener> listeners;
    private HostInfo info;
    private MetaDataStore metaDataStore;
    private Field sysPathsField;

    public ClassLoaderBuilderImpl(@Reference ClassLoaderWireBuilder wireBuilder, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference ClasspathProcessorRegistry classpathProcessorRegistry, @Reference ContributionResolver resolver, @Reference ClassLoaderTracker tracker, @Reference MetaDataStore metaDataStore, @Reference HostInfo info, @Monitor ClassLoaderBuilderMonitor monitor) {
        this.wireBuilder = wireBuilder;
        this.classLoaderRegistry = classLoaderRegistry;
        this.classpathProcessorRegistry = classpathProcessorRegistry;
        this.resolver = resolver;
        this.tracker = tracker;
        this.metaDataStore = metaDataStore;
        this.info = info;
        this.listeners = Collections.emptyList();
        this.initializeSysPaths(info, monitor);
    }

    @Reference(required=false)
    public void setListeners(List<ClassLoaderListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void build(PhysicalClassLoaderDefinition definition) throws ClassLoaderBuilderException {
        URI uri = definition.getUri();
        int count = this.tracker.increment(uri);
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(uri);
        if (classLoader != null) {
            for (PhysicalClassLoaderWireDefinition wireDefinition : definition.getWireDefinitions()) {
                URI target = wireDefinition.getTargetClassLoader();
                classLoader = this.classLoaderRegistry.getClassLoader(target);
                this.tracker.incrementImported(classLoader);
            }
            this.notifyListenersBuild(count, classLoader);
            return;
        }
        if (this.info.supportsClassLoaderIsolation()) {
            this.buildIsolatedClassLoaderEnvironment(definition);
        } else {
            this.buildCommonClassLoaderEnvironment(definition);
        }
        this.notifyListenersBuild(count, classLoader);
    }

    @Override
    public void destroy(URI uri) throws ClassLoaderBuilderException {
        block5: {
            int val;
            ClassLoader classLoader;
            block4: {
                classLoader = this.classLoaderRegistry.getClassLoader(uri);
                val = this.tracker.decrement(classLoader);
                if (val != 0 || this.metaDataStore.find(uri) != null) break block4;
                try {
                    this.classLoaderRegistry.unregister(uri);
                    this.resolver.release(uri);
                }
                catch (ResolutionException e) {
                    throw new ClassLoaderBuilderException("Error releasing artifact: " + uri.toString(), e);
                }
                for (ClassLoaderListener listener : this.listeners) {
                    listener.onUndeploy(classLoader);
                }
                break block5;
            }
            if (val != 0) break block5;
            for (ClassLoaderListener listener : this.listeners) {
                listener.onUndeploy(classLoader);
            }
        }
    }

    private void notifyListenersBuild(int count, ClassLoader classLoader) {
        if (count == 1) {
            for (ClassLoaderListener listener : this.listeners) {
                listener.onDeploy(classLoader);
            }
        }
    }

    private void buildCommonClassLoaderEnvironment(PhysicalClassLoaderDefinition definition) {
        URI uri = definition.getUri();
        ClassLoader hostClassLoader = this.classLoaderRegistry.getClassLoader(Names.HOST_CONTRIBUTION);
        this.classLoaderRegistry.register(uri, hostClassLoader);
    }

    private void buildIsolatedClassLoaderEnvironment(PhysicalClassLoaderDefinition definition) throws ClassLoaderBuilderException {
        MultiParentClassLoader loader;
        URI uri = definition.getUri();
        ClassLoader hostClassLoader = this.classLoaderRegistry.getClassLoader(Names.HOST_CONTRIBUTION);
        if (definition.isProvisionArtifact()) {
            URL[] classpath = this.resolveClasspath(definition);
            loader = new MultiParentClassLoader(uri, classpath, hostClassLoader);
            this.setSysPathsField(loader);
        } else {
            loader = new MultiParentClassLoader(uri, hostClassLoader);
        }
        for (PhysicalClassLoaderWireDefinition wireDefinition : definition.getWireDefinitions()) {
            this.wireBuilder.build(loader, wireDefinition);
            URI target = wireDefinition.getTargetClassLoader();
            ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(target);
            this.tracker.incrementImported(classLoader);
        }
        this.classLoaderRegistry.register(uri, (ClassLoader)loader);
    }

    private URL[] resolveClasspath(PhysicalClassLoaderDefinition definition) throws ClassLoaderBuilderException {
        URI uri = definition.getUri();
        try {
            URL resolvedUrl = this.resolver.resolve(uri);
            ArrayList classpath = new ArrayList();
            List libraries = definition.getLibraries();
            List archiveClasspath = this.classpathProcessorRegistry.process(resolvedUrl, libraries);
            classpath.addAll(archiveClasspath);
            return classpath.toArray(new URL[classpath.size()]);
        }
        catch (ResolutionException e) {
            throw new ClassLoaderBuilderException("Error resolving artifact: " + uri.toString(), e);
        }
        catch (IOException e) {
            throw new ClassLoaderBuilderException("Error processing: " + uri.toString(), e);
        }
    }

    private void setSysPathsField(MultiParentClassLoader loader) {
        if (this.sysPathsField == null) {
            return;
        }
        try {
            this.sysPathsField.set(loader, null);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void initializeSysPaths(HostInfo info, ClassLoaderBuilderMonitor monitor) {
        block2: {
            try {
                this.sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
                this.sysPathsField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if (RuntimeMode.PARTICIPANT != info.getRuntimeMode()) break block2;
                monitor.nativeLibrariesNotSupported();
            }
        }
    }
}

