/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder.channel;

import java.net.URI;
import org.fabric3.fabric.container.builder.channel.ChannelNotFoundException;
import org.fabric3.fabric.model.physical.ChannelTargetDefinition;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ChannelTargetAttacher
implements TargetConnectionAttacher<ChannelTargetDefinition> {
    private ChannelManager channelManager;

    public ChannelTargetAttacher(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    public void attach(PhysicalConnectionSourceDefinition source, ChannelTargetDefinition target, ChannelConnection connection) throws ContainerException {
        URI uri = target.getUri();
        Channel channel = this.getChannel(uri, target.getChannelSide());
        channel.attach(connection);
    }

    public void detach(PhysicalConnectionSourceDefinition source, ChannelTargetDefinition target) throws ContainerException {
    }

    private Channel getChannel(URI uri, ChannelSide channelSide) throws ChannelNotFoundException {
        Channel channel = this.channelManager.getChannel(uri, channelSide);
        if (channel == null) {
            throw new ChannelNotFoundException("Channel not found");
        }
        return channel;
    }
}

