/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder.channel;

import java.net.URI;
import org.fabric3.fabric.container.builder.channel.ChannelNotFoundException;
import org.fabric3.fabric.model.physical.ChannelSourceDefinition;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ChannelSourceAttacher
implements SourceConnectionAttacher<ChannelSourceDefinition> {
    private ChannelManager channelManager;

    public ChannelSourceAttacher(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    public void attach(ChannelSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        URI uri = source.getUri();
        Channel channel = this.getChannel(uri, source.getChannelSide());
        URI targetUri = target.getUri();
        channel.subscribe(targetUri, connection);
    }

    public void detach(ChannelSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ContainerException {
        URI uri = source.getUri();
        Channel channel = this.getChannel(uri, source.getChannelSide());
        URI targetUri = target.getUri();
        channel.unsubscribe(targetUri);
    }

    private Channel getChannel(URI uri, ChannelSide channelSide) throws ChannelNotFoundException {
        Channel channel = this.channelManager.getChannel(uri, channelSide);
        if (channel == null) {
            throw new ChannelNotFoundException("Channel not found");
        }
        return channel;
    }
}

