/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder.channel;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.channel.ChannelBuilder;
import org.fabric3.spi.container.builder.channel.ChannelBuilderRegistry;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.container.channel.RegistrationException;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ChannelBuilderRegistryImpl
implements ChannelBuilderRegistry {
    private ChannelManager channelManager;
    private Map<String, ChannelBuilder> builders = new HashMap<String, ChannelBuilder>();

    public ChannelBuilderRegistryImpl(@Reference ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    @Reference(required=false)
    public void setBuilders(Map<String, ChannelBuilder> builders) {
        this.builders = builders;
    }

    public Channel build(PhysicalChannelDefinition definition) throws ContainerException {
        ChannelSide channelSide;
        URI uri = definition.getUri();
        Channel channel = this.channelManager.getAndIncrementChannel(uri, channelSide = definition.getChannelSide());
        if (channel != null) {
            return channel;
        }
        ChannelBuilder builder = this.getBuilder(definition);
        channel = builder.build(definition);
        try {
            this.channelManager.register(channel);
            return channel;
        }
        catch (RegistrationException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    public void dispose(PhysicalChannelDefinition definition) throws ContainerException {
        ChannelBuilder builder = this.getBuilder(definition);
        try {
            URI uri = definition.getUri();
            ChannelSide channelSide = definition.getChannelSide();
            Channel channel = this.channelManager.getAndDecrementChannel(uri, channelSide);
            if (this.channelManager.getCount(uri, channelSide) == 0) {
                this.channelManager.unregister(uri, channelSide);
                builder.dispose(definition, channel);
            }
        }
        catch (RegistrationException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    private ChannelBuilder getBuilder(PhysicalChannelDefinition definition) throws ContainerException {
        ChannelBuilder builder = this.builders.get(definition.getType());
        if (builder == null) {
            throw new ContainerException("Channel builder not found for type " + definition.getType());
        }
        return builder;
    }
}

