/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.fabric.container.builder.AttacherNotFoundException;
import org.fabric3.fabric.container.wire.InvocationChainImpl;
import org.fabric3.fabric.container.wire.WireImpl;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.Connector;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.builder.interceptor.InterceptorBuilder;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.TransformerInterceptorFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalInterceptorDefinition;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;

public class ConnectorImpl
implements Connector {
    private Map<Class<? extends PhysicalInterceptorDefinition>, InterceptorBuilder<?>> interceptorBuilders;
    private Map<Class<? extends PhysicalWireSourceDefinition>, SourceWireAttacher<? extends PhysicalWireSourceDefinition>> sourceAttachers;
    private Map<Class<? extends PhysicalWireTargetDefinition>, TargetWireAttacher<? extends PhysicalWireTargetDefinition>> targetAttachers;
    private ClassLoaderRegistry classLoaderRegistry;
    private TransformerInterceptorFactory transformerFactory;
    private boolean transform;

    public ConnectorImpl() {
    }

    @Constructor
    public ConnectorImpl(@Reference ClassLoaderRegistry classLoaderRegistry, @Reference TransformerInterceptorFactory transformerFactory) {
        this.classLoaderRegistry = classLoaderRegistry;
        this.transformerFactory = transformerFactory;
        this.transform = true;
    }

    @Reference
    public void setInterceptorBuilders(Map<Class<? extends PhysicalInterceptorDefinition>, InterceptorBuilder<?>> interceptorBuilders) {
        this.interceptorBuilders = interceptorBuilders;
    }

    @Reference(required=false)
    public void setSourceAttachers(Map<Class<? extends PhysicalWireSourceDefinition>, SourceWireAttacher<? extends PhysicalWireSourceDefinition>> sourceAttachers) {
        this.sourceAttachers = sourceAttachers;
    }

    @Reference
    public void setTargetAttachers(Map<Class<? extends PhysicalWireTargetDefinition>, TargetWireAttacher<? extends PhysicalWireTargetDefinition>> targetAttachers) {
        this.targetAttachers = targetAttachers;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public void connect(PhysicalWireDefinition definition) throws ContainerException {
        PhysicalWireSourceDefinition sourceDefinition = definition.getSource();
        SourceWireAttacher<PhysicalWireSourceDefinition> sourceAttacher = this.getAttacher(sourceDefinition);
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Source attacher not found for type: " + sourceDefinition.getClass());
        }
        PhysicalWireTargetDefinition targetDefinition = definition.getTarget();
        TargetWireAttacher<PhysicalWireTargetDefinition> targetAttacher = this.getAttacher(targetDefinition);
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Target attacher not found for type: " + targetDefinition.getClass());
        }
        if (definition.isOptimizable()) {
            ObjectFactory objectFactory = targetAttacher.createObjectFactory(targetDefinition);
            sourceAttacher.attachObjectFactory(sourceDefinition, objectFactory, targetDefinition);
        } else {
            Wire wire = this.createWire(definition);
            sourceAttacher.attach(sourceDefinition, targetDefinition, wire);
            targetAttacher.attach(sourceDefinition, targetDefinition, wire);
        }
    }

    public void disconnect(PhysicalWireDefinition definition) throws ContainerException {
        PhysicalWireSourceDefinition sourceDefinition = definition.getSource();
        SourceWireAttacher<PhysicalWireSourceDefinition> sourceAttacher = this.getAttacher(sourceDefinition);
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Source attacher not found for type: " + sourceDefinition.getClass());
        }
        PhysicalWireTargetDefinition targetDefinition = definition.getTarget();
        if (definition.isOptimizable()) {
            sourceAttacher.detachObjectFactory(sourceDefinition, targetDefinition);
        } else {
            TargetWireAttacher<PhysicalWireTargetDefinition> targetAttacher = this.getAttacher(targetDefinition);
            if (targetAttacher == null) {
                throw new AttacherNotFoundException("Target attacher not found for type: " + targetDefinition.getClass());
            }
            targetAttacher.detach(sourceDefinition, targetDefinition);
            sourceAttacher.detach(sourceDefinition, targetDefinition);
        }
    }

    Wire createWire(PhysicalWireDefinition definition) throws ContainerException {
        WireImpl wire = new WireImpl();
        for (PhysicalOperationDefinition operation : definition.getOperations()) {
            InvocationChainImpl chain = new InvocationChainImpl(operation);
            for (PhysicalInterceptorDefinition interceptorDefinition : operation.getInterceptors()) {
                InterceptorBuilder<PhysicalInterceptorDefinition> builder = this.getBuilder(interceptorDefinition);
                Interceptor interceptor = builder.build(interceptorDefinition);
                chain.addInterceptor(interceptor);
            }
            wire.addInvocationChain(chain);
        }
        this.processTransform(wire, definition);
        return wire;
    }

    private void processTransform(Wire wire, PhysicalWireDefinition definition) throws ContainerException {
        if (!this.transform) {
            return;
        }
        PhysicalWireSourceDefinition sourceDefinition = definition.getSource();
        PhysicalWireTargetDefinition targetDefinition = definition.getTarget();
        for (DataType sourceType : sourceDefinition.getDataTypes()) {
            if (!targetDefinition.getDataTypes().contains(sourceType)) continue;
            this.addTransformer(wire, definition, true);
            return;
        }
        this.addTransformer(wire, definition, false);
    }

    private void addTransformer(Wire wire, PhysicalWireDefinition definition, boolean checkPassByRef) throws ContainerException {
        PhysicalWireSourceDefinition sourceDefinition = definition.getSource();
        PhysicalWireTargetDefinition targetDefinition = definition.getTarget();
        URI sourceId = sourceDefinition.getClassLoaderId();
        URI targetId = targetDefinition.getClassLoaderId();
        ClassLoader sourceLoader = null;
        ClassLoader targetLoader = null;
        for (InvocationChain chain : wire.getInvocationChains()) {
            if (checkPassByRef && chain.getPhysicalOperation().isAllowsPassByReference()) continue;
            if (sourceLoader == null && targetLoader == null) {
                sourceLoader = this.classLoaderRegistry.getClassLoader(sourceId);
                targetLoader = this.classLoaderRegistry.getClassLoader(targetId);
            }
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            List sourceTypes = sourceDefinition.getDataTypes();
            List targetTypes = targetDefinition.getDataTypes();
            Interceptor interceptor = this.transformerFactory.createInterceptor(operation, sourceTypes, targetTypes, targetLoader, sourceLoader);
            chain.addInterceptor(interceptor);
        }
    }

    private <PID extends PhysicalInterceptorDefinition> InterceptorBuilder<PID> getBuilder(PID definition) {
        return this.interceptorBuilders.get(definition.getClass());
    }

    private <PSD extends PhysicalWireSourceDefinition> SourceWireAttacher<PSD> getAttacher(PSD source) {
        return this.sourceAttachers.get(source.getClass());
    }

    private <PSD extends PhysicalWireTargetDefinition> TargetWireAttacher<PSD> getAttacher(PSD target) {
        return this.targetAttachers.get(target.getClass());
    }
}

