/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.fabric.container.builder.AttacherNotFoundException;
import org.fabric3.fabric.container.channel.ChannelConnectionImpl;
import org.fabric3.fabric.container.channel.EventStreamImpl;
import org.fabric3.fabric.container.channel.FilterHandler;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.ChannelConnector;
import org.fabric3.spi.container.builder.channel.EventFilter;
import org.fabric3.spi.container.builder.channel.EventFilterBuilder;
import org.fabric3.spi.container.builder.channel.EventStreamHandlerBuilder;
import org.fabric3.spi.container.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.container.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.channel.HandlerCreationException;
import org.fabric3.spi.container.channel.TransformerHandlerFactory;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalEventFilterDefinition;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.fabric3.spi.model.physical.PhysicalHandlerDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ChannelConnectorImpl
implements ChannelConnector {
    private Map<Class<? extends PhysicalConnectionSourceDefinition>, SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition>> sourceAttachers;
    private Map<Class<? extends PhysicalConnectionTargetDefinition>, TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition>> targetAttachers;
    private Map<Class<? extends PhysicalEventFilterDefinition>, EventFilterBuilder<? extends PhysicalEventFilterDefinition>> filterBuilders;
    private Map<Class<? extends PhysicalHandlerDefinition>, EventStreamHandlerBuilder<? extends PhysicalHandlerDefinition>> handlerBuilders;
    private ClassLoaderRegistry classLoaderRegistry;
    private TransformerHandlerFactory transformerHandlerFactory;

    @Reference
    public void setClassLoaderRegistry(ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Reference(required=false)
    public void setSourceAttachers(Map<Class<? extends PhysicalConnectionSourceDefinition>, SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition>> sourceAttachers) {
        this.sourceAttachers = sourceAttachers;
    }

    @Reference(required=false)
    public void setTargetAttachers(Map<Class<? extends PhysicalConnectionTargetDefinition>, TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition>> targetAttachers) {
        this.targetAttachers = targetAttachers;
    }

    @Reference(required=false)
    public void setFilterBuilders(Map<Class<? extends PhysicalEventFilterDefinition>, EventFilterBuilder<? extends PhysicalEventFilterDefinition>> filterBuilders) {
        this.filterBuilders = filterBuilders;
    }

    @Reference(required=false)
    public void setHandlerBuilders(Map<Class<? extends PhysicalHandlerDefinition>, EventStreamHandlerBuilder<? extends PhysicalHandlerDefinition>> handlerBuilders) {
        this.handlerBuilders = handlerBuilders;
    }

    @Reference(required=false)
    public void setTransformerHandlerFactory(TransformerHandlerFactory factory) {
        this.transformerHandlerFactory = factory;
    }

    public void connect(PhysicalChannelConnectionDefinition definition) throws ContainerException {
        PhysicalConnectionSourceDefinition source = definition.getSource();
        PhysicalConnectionTargetDefinition target = definition.getTarget();
        SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + target.getClass().getName());
        }
        ChannelConnection connection = this.createConnection(definition);
        sourceAttacher.attach(source, target, connection);
        targetAttacher.attach(source, target, connection);
    }

    public void disconnect(PhysicalChannelConnectionDefinition definition) throws ContainerException {
        PhysicalConnectionSourceDefinition source = definition.getSource();
        PhysicalConnectionTargetDefinition target = definition.getTarget();
        SourceConnectionAttacher<? extends PhysicalConnectionSourceDefinition> sourceAttacher = this.sourceAttachers.get(source.getClass());
        if (sourceAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + source.getClass().getName());
        }
        TargetConnectionAttacher<? extends PhysicalConnectionTargetDefinition> targetAttacher = this.targetAttachers.get(target.getClass());
        if (targetAttacher == null) {
            throw new AttacherNotFoundException("Attacher not found for type: " + target.getClass().getName());
        }
        sourceAttacher.detach(source, target);
        targetAttacher.detach(source, target);
    }

    private ChannelConnection createConnection(PhysicalChannelConnectionDefinition definition) throws ContainerException {
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(definition.getTarget().getClassLoaderId());
        PhysicalEventStreamDefinition streamDefinition = definition.getEventStream();
        EventStreamImpl stream = new EventStreamImpl(streamDefinition);
        this.addTypeTransformer(definition, stream, loader);
        this.addFilters(streamDefinition, stream);
        this.addHandlers(streamDefinition, stream);
        int sequence = definition.getSource().getSequence();
        return new ChannelConnectionImpl(stream, sequence);
    }

    private void addTypeTransformer(PhysicalChannelConnectionDefinition definition, EventStream stream, ClassLoader loader) throws ContainerException {
        DataType targetType;
        if (this.transformerHandlerFactory == null) {
            return;
        }
        List sourceTypes = definition.getSource().getDataTypes();
        List targetTypes = definition.getTarget().getDataTypes();
        if (sourceTypes.isEmpty() || targetTypes.isEmpty()) {
            return;
        }
        if (sourceTypes.size() > 1 || targetTypes.size() > 1) {
            throw new ContainerException("Multi-type events are not supported");
        }
        DataType sourceType = (DataType)sourceTypes.get(0);
        if (sourceType.equals((Object)(targetType = (DataType)targetTypes.get(0)))) {
            return;
        }
        try {
            ArrayList eventTypes = new ArrayList();
            for (String type : stream.getDefinition().getEventTypes()) {
                Class<?> clazz = loader.loadClass(type);
                eventTypes.add(clazz);
            }
            EventStreamHandler handler = this.transformerHandlerFactory.createHandler(sourceType, targetType, eventTypes, loader);
            stream.addHandler(handler);
        }
        catch (ClassNotFoundException | HandlerCreationException e) {
            throw new ContainerException(e);
        }
    }

    private void addFilters(PhysicalEventStreamDefinition streamDefinition, EventStream stream) throws ContainerException {
        for (PhysicalEventFilterDefinition definition : streamDefinition.getFilters()) {
            EventFilterBuilder<? extends PhysicalEventFilterDefinition> builder = this.filterBuilders.get(definition.getClass());
            EventFilter filter = builder.build(definition);
            FilterHandler handler = new FilterHandler(filter);
            stream.addHandler((EventStreamHandler)handler);
        }
    }

    private void addHandlers(PhysicalEventStreamDefinition streamDefinition, EventStream stream) throws ContainerException {
        for (PhysicalHandlerDefinition definition : streamDefinition.getHandlers()) {
            EventStreamHandlerBuilder<? extends PhysicalHandlerDefinition> builder = this.handlerBuilders.get(definition.getClass());
            EventStreamHandler handler = builder.build(definition);
            stream.addHandler(handler);
        }
    }
}

