/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.fabric.container.binding.BindingHandlerLazyLoadDecorator;
import org.fabric3.spi.container.binding.handler.BindingHandler;
import org.fabric3.spi.container.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.container.binding.handler.BindingHandlerRegistryCallback;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.oasisopen.sca.annotation.Reference;

public class BindingHandlerRegistryImpl
implements BindingHandlerRegistry {
    private ComponentManager componentManager;
    private Map<QName, BindingHandlerRegistryCallback<?>> callbacks = new HashMap();
    private Map<QName, List<BindingHandler<?>>> handlers = new HashMap();

    public BindingHandlerRegistryImpl(@Reference ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public <T> BindingHandler<T> createHandler(Class<T> type, PhysicalBindingHandlerDefinition definition) {
        return new BindingHandlerLazyLoadDecorator(definition.getHandlerUri(), this.componentManager);
    }

    public synchronized void register(BindingHandlerRegistryCallback callback) {
        QName binding = callback.getType();
        if (this.callbacks.containsKey(binding)) {
            throw new IllegalStateException("Callback already registered for " + binding);
        }
        this.callbacks.put(binding, callback);
        List<BindingHandler<?>> list = this.handlers.get(binding);
        if (list != null) {
            callback.update(Collections.unmodifiableList(list));
        }
    }

    public synchronized void unregister(BindingHandlerRegistryCallback<?> callback) {
        QName binding = callback.getType();
        if (this.callbacks.remove(binding) == null) {
            throw new IllegalStateException("Callback not registered for " + binding);
        }
    }

    public synchronized void register(BindingHandler<?> handler) {
        QName binding = handler.getType();
        List<BindingHandler<?>> list = this.handlers.get(binding);
        if (list == null) {
            list = new ArrayList();
            this.handlers.put(binding, list);
        }
        list.add(handler);
        BindingHandlerRegistryCallback<?> callback = this.callbacks.get(binding);
        if (callback != null) {
            callback.update(Collections.unmodifiableList(list));
        }
    }

    public synchronized void unregister(BindingHandler<?> handler) {
        BindingHandlerRegistryCallback<?> callback;
        QName binding = handler.getType();
        List<BindingHandler<?>> list = this.handlers.get(binding);
        if (list == null || !list.remove(handler)) {
            throw new IllegalStateException("Handler not registered for binding " + binding);
        }
        if (list.isEmpty()) {
            this.handlers.remove(binding);
        }
        if ((callback = this.callbacks.get(binding)) != null) {
            callback.update(Collections.unmodifiableList(list));
        }
    }
}

