/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.node.snapshot;

import java.net.URI;
import java.util.ArrayList;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.ChannelDefinition;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.CompositeImplementation;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.ServiceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.remote.RemoteImplementation;
import org.fabric3.spi.model.type.remote.RemoteServiceContract;

public class SnapshotHelper {
    public static LogicalCompositeComponent snapshot(LogicalCompositeComponent domain, LogicalState state) {
        return SnapshotHelper.snapshot(domain, null, state);
    }

    public static LogicalCompositeComponent snapshot(LogicalCompositeComponent domain, URI uri, LogicalState state) {
        String domainName = domain.getDefinition().getName();
        Composite typeCopy = new Composite(null);
        CompositeImplementation implementationCopy = new CompositeImplementation();
        implementationCopy.setComponentType((ComponentType)typeCopy);
        ComponentDefinition compositeCopy = new ComponentDefinition(domainName, (Implementation)implementationCopy);
        LogicalCompositeComponent domainCopy = new LogicalCompositeComponent(domain.getUri(), compositeCopy, null);
        for (LogicalComponent component : domain.getComponents()) {
            if (uri != null && !uri.equals(component.getDefinition().getContributionUri()) || !SnapshotHelper.isReplicable(component)) continue;
            LogicalComponent<?> componentCopy = SnapshotHelper.snapshot(component, state, domainCopy);
            domainCopy.addComponent(componentCopy);
        }
        for (LogicalChannel channel : domain.getChannels()) {
            if (channel.getBindings().isEmpty()) continue;
            LogicalChannel channelCopy = SnapshotHelper.snapshot(channel, typeCopy, state, domainCopy);
            domainCopy.addChannel(channelCopy);
        }
        return domainCopy;
    }

    static LogicalChannel snapshot(LogicalChannel channel, Composite composite, LogicalState state, LogicalCompositeComponent domain) {
        ChannelDefinition definition = channel.getDefinition();
        String name = definition.getName();
        URI contributionUri = definition.getContributionUri();
        String type = definition.getType();
        boolean local = definition.isLocal();
        ChannelDefinition definitionCopy = new ChannelDefinition(name, contributionUri, type, local);
        definitionCopy.setParent((ModelObject)composite);
        definitionCopy.setIntents(definition.getIntents());
        definitionCopy.setPolicySets(definition.getPolicySets());
        definitionCopy.setLocal(definition.isLocal());
        LogicalChannel channelCopy = new LogicalChannel(channel.getUri(), definitionCopy, domain);
        channelCopy.getBindings().addAll(channel.getBindings());
        channelCopy.setDeployable(channel.getDeployable());
        channelCopy.setZone(channel.getZone());
        channelCopy.setState(state);
        return channelCopy;
    }

    static LogicalComponent<?> snapshot(LogicalComponent<?> component, LogicalState state, LogicalCompositeComponent parent) {
        ComponentDefinition definition = component.getDefinition();
        String name = definition.getName();
        RemoteImplementation remoteImplementation = new RemoteImplementation();
        ComponentType typeCopy = new ComponentType();
        ComponentType type = definition.getComponentType();
        for (AbstractService abstractDefinition : type.getServices().values()) {
            ServiceDefinition serviceDefinitionCopy = SnapshotHelper.snapshot(abstractDefinition);
            typeCopy.add(serviceDefinitionCopy);
        }
        remoteImplementation.setComponentType(typeCopy);
        ComponentDefinition definitionCopy = new ComponentDefinition(name, (Implementation)remoteImplementation);
        Composite composite = (Composite)parent.getDefinition().getComponentType();
        definitionCopy.setParent((ModelObject)composite);
        definitionCopy.setContributionUri(definition.getContributionUri());
        definitionCopy.setIntents(definition.getIntents());
        definitionCopy.setPolicySets(definition.getPolicySets());
        URI uri = component.getUri();
        LogicalComponent componentCopy = new LogicalComponent(uri, definitionCopy, parent);
        componentCopy.setDeployable(component.getDeployable());
        componentCopy.setZone(component.getZone());
        componentCopy.setState(state);
        for (LogicalService service : component.getServices()) {
            LogicalService serviceCopy = SnapshotHelper.snapshot(service, (LogicalComponent<RemoteImplementation>)componentCopy);
            componentCopy.addService(serviceCopy);
        }
        return componentCopy;
    }

    static LogicalService snapshot(LogicalService service, LogicalComponent<RemoteImplementation> parent) {
        AbstractService abstractDefinition = service.getDefinition();
        ServiceDefinition serviceDefinitionCopy = SnapshotHelper.snapshot(abstractDefinition);
        URI serviceUri = service.getUri();
        LogicalService serviceCopy = new LogicalService(serviceUri, (AbstractService)serviceDefinitionCopy, parent);
        serviceCopy.getBindings().addAll(service.getBindings());
        return serviceCopy;
    }

    static ServiceDefinition snapshot(AbstractService abstractDefinition) {
        ServiceContract contract = abstractDefinition.getServiceContract();
        String serviceName = abstractDefinition.getName();
        RemoteServiceContract contractCopy = SnapshotHelper.snapshot(contract);
        return new ServiceDefinition(serviceName, (ServiceContract)contractCopy);
    }

    static RemoteServiceContract snapshot(ServiceContract contract) {
        String interfaceName = contract.getQualifiedInterfaceName();
        ArrayList superTypes = new ArrayList();
        if (contract instanceof JavaServiceContract) {
            JavaServiceContract javaContract = (JavaServiceContract)contract;
            superTypes.addAll(javaContract.getInterfaces());
        }
        RemoteServiceContract contractCopy = new RemoteServiceContract(interfaceName, superTypes);
        ServiceContract callbackContract = contract.getCallbackContract();
        if (callbackContract != null) {
            RemoteServiceContract callbackContractCopy = SnapshotHelper.snapshot(callbackContract);
            contractCopy.setCallbackContract((ServiceContract)callbackContractCopy);
        }
        return contractCopy;
    }

    private static boolean isReplicable(LogicalComponent<?> component) {
        for (LogicalService service : component.getServices()) {
            ServiceContract contract = service.getLeafService().getServiceContract();
            if (!contract.isRemotable() && service.getBindings().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private SnapshotHelper() {
    }
}

