/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.node.merge;

import java.util.Iterator;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.federation.node.merge.DomainMergeService;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.oasisopen.sca.annotation.Reference;

public class DomainMergeServiceImpl
implements DomainMergeService {
    private LogicalComponentManager lcm;
    private String zoneName;

    public DomainMergeServiceImpl(@Reference(name="lcm") LogicalComponentManager lcm, @Reference HostInfo info) {
        this.lcm = lcm;
        this.zoneName = info.getZoneName();
    }

    @Override
    public void merge(LogicalCompositeComponent snapshot) {
        LogicalCompositeComponent domain = this.lcm.getRootComponent();
        for (LogicalComponent component : snapshot.getComponents()) {
            if (this.zoneName.equals(component.getZone())) continue;
            if (LogicalState.NEW == component.getState()) {
                component.setState(LogicalState.PROVISIONED);
                domain.addComponent(component);
                continue;
            }
            if (LogicalState.MARKED != component.getState()) continue;
            domain.removeComponent(component.getUri());
        }
        for (LogicalChannel channel : snapshot.getChannels()) {
            if (this.zoneName.equals(channel.getZone())) continue;
            if (LogicalState.NEW == channel.getState()) {
                channel.setState(LogicalState.PROVISIONED);
                domain.addChannel(channel);
                continue;
            }
            if (LogicalState.MARKED != channel.getState()) continue;
            domain.removeChannel(channel.getUri());
        }
    }

    @Override
    public void drop(String zone) {
        LogicalCompositeComponent domain = this.lcm.getRootComponent();
        Iterator iterator = domain.getComponents().iterator();
        while (iterator.hasNext()) {
            LogicalComponent component = (LogicalComponent)iterator.next();
            if (!zone.equals(component.getZone())) continue;
            iterator.remove();
        }
        iterator = domain.getChannels().iterator();
        while (iterator.hasNext()) {
            LogicalChannel channel = (LogicalChannel)iterator.next();
            if (!zone.equals(channel.getZone())) continue;
            iterator.remove();
        }
    }
}

