/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.node.executor;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.federation.node.command.DomainSnapshotCommand;
import org.fabric3.federation.node.command.DomainSnapshotResponse;
import org.fabric3.federation.node.snapshot.SnapshotHelper;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.domain.DeployListener;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DomainSnapshotCommandExecutor
implements CommandExecutor<DomainSnapshotCommand>,
DeployListener {
    private CommandExecutorRegistry executorRegistry;
    private LogicalComponentManager lcm;
    private LogicalCompositeComponent snapshot;

    public DomainSnapshotCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference(name="lcm") LogicalComponentManager lcm) {
        this.executorRegistry = executorRegistry;
        this.lcm = lcm;
    }

    @Init
    public void init() {
        this.executorRegistry.register(DomainSnapshotCommand.class, (CommandExecutor)this);
    }

    public synchronized void execute(DomainSnapshotCommand command) throws ContainerException {
        if (this.snapshot == null) {
            LogicalCompositeComponent domain = this.lcm.getRootComponent();
            this.snapshot = SnapshotHelper.snapshot(domain, LogicalState.NEW);
        }
        DomainSnapshotResponse response = new DomainSnapshotResponse(this.snapshot);
        command.setResponse(response);
    }

    public synchronized void onDeploy(URI uri) {
        this.snapshot = null;
    }

    public synchronized void onUnDeploy(URI uri) {
        this.snapshot = null;
    }

    public void onDeployCompleted(URI uri) {
    }

    public void onUnDeployCompleted(URI uri) {
    }

    public void onDeploy(QName deployable) {
    }

    public void onDeployCompleted(QName deployable) {
    }

    public void onUndeploy(QName undeployed) {
    }

    public void onUndeployCompleted(QName undeployed) {
    }
}

