/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.node.executor;

import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.federation.node.command.DeploymentSnapshotCommand;
import org.fabric3.federation.node.executor.DeploymentMonitor;
import org.fabric3.federation.node.merge.DomainMergeService;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DeploymentSnapshotCommandExecutor
implements CommandExecutor<DeploymentSnapshotCommand> {
    private CommandExecutorRegistry executorRegistry;
    private DomainMergeService mergeService;
    private DeploymentMonitor monitor;

    public DeploymentSnapshotCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference DomainMergeService mergeService, @Monitor DeploymentMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.mergeService = mergeService;
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.executorRegistry.register(DeploymentSnapshotCommand.class, (CommandExecutor)this);
    }

    public void execute(DeploymentSnapshotCommand command) throws ContainerException {
        this.monitor.received(command.getRuntimeName());
        this.mergeService.merge(command.getSnapshot());
    }
}

