/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.federation.node.deploy;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.federation.node.command.DeploymentSnapshotCommand;
import org.fabric3.federation.node.deploy.ListenerMonitor;
import org.fabric3.federation.node.snapshot.SnapshotHelper;
import org.fabric3.spi.container.command.Command;
import org.fabric3.spi.domain.DeployListener;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.federation.topology.MessageException;
import org.fabric3.spi.federation.topology.NodeTopologyService;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SnapshotDeployListener
implements DeployListener {
    private LogicalComponentManager lcm;
    private NodeTopologyService topologyService;
    private HostInfo info;
    private ListenerMonitor monitor;

    public SnapshotDeployListener(@Reference(name="lcm") LogicalComponentManager lcm, @Reference NodeTopologyService topologyService, @Reference HostInfo info, @Monitor ListenerMonitor monitor) {
        this.lcm = lcm;
        this.topologyService = topologyService;
        this.info = info;
        this.monitor = monitor;
    }

    public void onDeployCompleted(URI uri) {
        this.broadcastSnapshot(uri, LogicalState.NEW);
    }

    public void onUnDeploy(URI uri) {
        this.broadcastSnapshot(uri, LogicalState.MARKED);
    }

    public void onUnDeployCompleted(URI uri) {
    }

    public void onDeploy(URI uri) {
    }

    public void onDeploy(QName deployable) {
    }

    public void onDeployCompleted(QName deployable) {
        if ("urn:fabric3.org:synthesized".equals(deployable.getNamespaceURI())) {
            this.broadcastSnapshot(Names.HOST_CONTRIBUTION, LogicalState.NEW);
        }
    }

    public void onUndeploy(QName undeployed) {
    }

    public void onUndeployCompleted(QName undeployed) {
    }

    private void broadcastSnapshot(URI uri, LogicalState state) {
        if (!this.topologyService.isZoneLeader()) {
            return;
        }
        try {
            LogicalCompositeComponent domain = this.lcm.getRootComponent();
            LogicalCompositeComponent snapshot = SnapshotHelper.snapshot(domain, uri, state);
            if (snapshot.getComponents().isEmpty() && snapshot.getChannels().isEmpty()) {
                return;
            }
            String runtimeName = this.info.getRuntimeName();
            DeploymentSnapshotCommand command = new DeploymentSnapshotCommand(runtimeName, snapshot);
            this.topologyService.broadcast((Command)command);
        }
        catch (MessageException e) {
            this.monitor.error(e);
        }
    }
}

