/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.datasource.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.datasource.spi.DataSourceRegistry;

@Management(name="DataSourceRegistry", path="/runtime/datasources")
public class DataSourceRegistryImpl
implements DataSourceRegistry {
    private Map<String, DataSource> dataSources = new ConcurrentHashMap<String, DataSource>();

    @ManagementOperation(path="/")
    public Set<String> getDataSourceNames() {
        return this.dataSources.keySet();
    }

    @Override
    public DataSource getDataSource(String name) {
        return this.dataSources.get(name);
    }

    @Override
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    public void register(String name, DataSource dataSource) {
        this.dataSources.put(name, dataSource);
    }

    @Override
    public DataSource unregister(String name) {
        return this.dataSources.remove(name);
    }
}

