/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.binding.jms.builder;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.binding.jms.model.CacheLevel;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.api.binding.jms.model.CreateOption;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.JmsBindingDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.binding.jms.model.MessageSelection;
import org.fabric3.api.binding.jms.model.ResponseDefinition;
import org.fabric3.api.model.type.builder.AbstractBuilder;

public class JmsBindingDefinitionBuilder
extends AbstractBuilder {
    private JmsBindingDefinition binding;

    public static JmsBindingDefinitionBuilder newBuilder() {
        return new JmsBindingDefinitionBuilder();
    }

    private JmsBindingDefinitionBuilder() {
        this("jms.binding");
    }

    private JmsBindingDefinitionBuilder(String name) {
        this.binding = new JmsBindingDefinition(name, new JmsBindingMetadata());
    }

    public JmsBindingDefinition build() {
        this.checkState();
        this.freeze();
        DestinationDefinition destinationDefinition = this.binding.getJmsMetadata().getDestination();
        if (destinationDefinition == null) {
            throw new IllegalArgumentException("Destination not defined for JMS binding");
        }
        String target = destinationDefinition.getName();
        URI bindingUri = URI.create("jms://" + target);
        this.binding.setGeneratedTargetUri(bindingUri);
        return this.binding;
    }

    public JmsBindingDefinitionBuilder policySet(QName policy) {
        this.checkState();
        this.binding.addPolicySet(policy);
        return this;
    }

    public JmsBindingDefinitionBuilder intent(QName intent) {
        this.checkState();
        this.binding.addIntent(intent);
        return this;
    }

    public JmsBindingDefinitionBuilder cacheLevel(CacheLevel level) {
        this.checkState();
        this.binding.getJmsMetadata().setCacheLevel(level);
        return this;
    }

    public JmsBindingDefinitionBuilder subscriptionId(String id) {
        this.checkState();
        this.binding.getJmsMetadata().setSubscriptionId(id);
        return this;
    }

    public JmsBindingDefinitionBuilder connectionFactoryName(String name) {
        this.checkState();
        this.binding.getJmsMetadata().getConnectionFactory().setName(name);
        return this;
    }

    public JmsBindingDefinitionBuilder connectionFactoryProperty(String name, String value) {
        this.checkState();
        this.binding.getJmsMetadata().getConnectionFactory().addProperty(name, value);
        return this;
    }

    public JmsBindingDefinitionBuilder connectionFactoryCreate(CreateOption option) {
        this.checkState();
        this.binding.getJmsMetadata().getConnectionFactory().setCreate(option);
        return this;
    }

    public JmsBindingDefinitionBuilder destination(String name, DestinationType type, CreateOption option) {
        this.checkState();
        DestinationDefinition definition = new DestinationDefinition();
        definition.setName(name);
        definition.setType(type);
        definition.setCreate(option);
        this.binding.getJmsMetadata().setDestination(definition);
        return this;
    }

    public JmsBindingDefinitionBuilder destination(String name, DestinationType type) {
        this.checkState();
        DestinationDefinition definition = new DestinationDefinition();
        definition.setName(name);
        definition.setType(type);
        this.binding.getJmsMetadata().setDestination(definition);
        return this;
    }

    public JmsBindingDefinitionBuilder correlationScheme(CorrelationScheme scheme) {
        this.checkState();
        this.binding.getJmsMetadata().setCorrelationScheme(scheme);
        return this;
    }

    public JmsBindingDefinitionBuilder durable(boolean durable) {
        this.checkState();
        this.binding.getJmsMetadata().setDurable(durable);
        return this;
    }

    public JmsBindingDefinitionBuilder idleLimit(int limit) {
        this.checkState();
        this.binding.getJmsMetadata().setIdleLimit(limit);
        return this;
    }

    public JmsBindingDefinitionBuilder jndiUrl(String url) {
        this.checkState();
        this.binding.getJmsMetadata().setJndiUrl(url);
        return this;
    }

    public JmsBindingDefinitionBuilder localDelivery(boolean delivery) {
        this.checkState();
        this.binding.getJmsMetadata().setLocalDelivery(delivery);
        return this;
    }

    public JmsBindingDefinitionBuilder maxMessages(int max) {
        this.checkState();
        this.binding.getJmsMetadata().setMaxMessagesToProcess(max);
        return this;
    }

    public JmsBindingDefinitionBuilder maxReceivers(int max) {
        this.checkState();
        this.binding.getJmsMetadata().setMaxReceivers(max);
        return this;
    }

    public JmsBindingDefinitionBuilder minReceivers(int min) {
        this.checkState();
        this.binding.getJmsMetadata().setMinReceivers(min);
        return this;
    }

    public JmsBindingDefinitionBuilder receiveTimeout(int timeout) {
        this.checkState();
        this.binding.getJmsMetadata().setReceiveTimeout(timeout);
        return this;
    }

    public JmsBindingDefinitionBuilder selector(String selector) {
        this.checkState();
        this.binding.getJmsMetadata().setMessageSelection(new MessageSelection(selector));
        return this;
    }

    public JmsBindingDefinitionBuilder recoveryInterval(long interval) {
        this.checkState();
        this.binding.getJmsMetadata().setRecoveryInterval(interval);
        return this;
    }

    public JmsBindingDefinitionBuilder response(ResponseDefinition definition) {
        this.checkState();
        this.binding.getJmsMetadata().setResponse(definition);
        return this;
    }

    public JmsBindingDefinitionBuilder responseTimeout(int timeout) {
        this.checkState();
        this.binding.getJmsMetadata().setResponseTimeout(timeout);
        return this;
    }

    public JmsBindingDefinitionBuilder uriSelector(String selector) {
        this.checkState();
        this.binding.getJmsMetadata().setUriMessageSelection(new MessageSelection(selector));
        return this;
    }
}

