/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.template;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.fabric3.spi.introspection.xml.DuplicateTemplateException;
import org.fabric3.spi.introspection.xml.TemplateRegistry;
import org.oasisopen.sca.annotation.Service;

@Service(value={TemplateRegistry.class})
public class TemplateRegistryImpl
implements TemplateRegistry,
ContributionServiceListener {
    private Map<String, Pair> cache = new ConcurrentHashMap<String, Pair>();

    public <T extends ModelObject> void register(String name, URI uri, T value) throws DuplicateTemplateException {
        if (this.cache.containsKey(name)) {
            throw new DuplicateTemplateException(name);
        }
        Pair pair = new Pair(uri, value);
        this.cache.put(name, pair);
    }

    public void unregister(String name) {
        this.cache.remove(name);
    }

    public <T extends ModelObject> T resolve(Class<T> type, String name) {
        Pair pair = this.cache.get(name);
        if (pair != null) {
            return (T)((ModelObject)type.cast(pair.object));
        }
        return null;
    }

    public void onUninstall(Contribution contribution) {
        URI uri = contribution.getUri();
        Iterator<Pair> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            Pair pair = iterator.next();
            if (!pair.contributionUri.equals(uri)) continue;
            iterator.remove();
        }
    }

    public void onRemove(Contribution contribution) {
    }

    public void onStore(Contribution contribution) {
    }

    public void onProcessManifest(Contribution contribution) {
    }

    public void onInstall(Contribution contribution) {
    }

    public void onUpdate(Contribution contribution) {
    }

    private class Pair {
        private URI contributionUri;
        private ModelObject object;

        private Pair(URI contributionUri, ModelObject object) {
            this.contributionUri = contributionUri;
            this.object = object;
        }
    }
}

