/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.definitions.IntentMap;
import org.fabric3.api.model.type.definitions.IntentQualifier;
import org.fabric3.api.model.type.definitions.PolicyPhase;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.introspection.xml.definitions.DuplicateIntentMap;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@EagerInit
public class PolicySetLoader
extends AbstractValidatingTypeLoader<PolicySet> {
    private final LoaderHelper helper;

    public PolicySetLoader(@Reference LoaderHelper helper) {
        this.addAttributes(new String[]{"name", "provides", "appliesTo", "phase", "attachTo"});
        this.helper = helper;
    }

    public PolicySet load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        PolicySet policySet = new PolicySet();
        this.validateAttributes(reader, context, new ModelObject[]{policySet});
        Element policyElement = this.helper.transform(reader).getDocumentElement();
        String name = policyElement.getAttribute("name");
        QName qName = new QName(context.getTargetNamespace(), name);
        policySet.setName(qName);
        HashSet<QName> provides = new HashSet<QName>();
        StringTokenizer tok = new StringTokenizer(policyElement.getAttribute("provides"));
        while (tok.hasMoreElements()) {
            try {
                provides.add(this.helper.createQName(tok.nextToken(), reader));
            }
            catch (InvalidPrefixException e) {
                this.raiseInvalidPrefix(startLocation, context, e);
                return null;
            }
        }
        policySet.setProvidedIntents(provides);
        String appliesTo = policyElement.getAttribute("appliesTo");
        String attachTo = policyElement.getAttribute("attachTo");
        policySet.setAppliesTo(appliesTo);
        policySet.setAttachTo(attachTo);
        Element expression = null;
        HashSet<IntentMap> intentMaps = new HashSet<IntentMap>();
        HashSet<QName> policySetReferences = new HashSet<QName>();
        NodeList children = policyElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName();
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("intentMap".equals(nodeName)) {
                this.parseIntentMaps(element, intentMaps, reader, context);
                continue;
            }
            if ("policySetReference".equals(nodeName)) {
                this.parsePolicyReference(element, policySetReferences, reader, startLocation, context);
                continue;
            }
            expression = (Element)children.item(i);
        }
        policySet.setExpression(expression);
        policySet.setIntentMaps(intentMaps);
        policySet.setPolicySetReferences(policySetReferences);
        PolicyPhase phase = this.parsePhase(expression, reader, context);
        policySet.setPhase(phase);
        URI uri = context.getContributionUri();
        policySet.setContributionUri(uri);
        this.validate(policySet, startLocation, context);
        return policySet;
    }

    private void parseIntentMaps(Element element, Set<IntentMap> intentMaps, XMLStreamReader reader, IntrospectionContext context) {
        Location startLocation = reader.getLocation();
        try {
            QName providedIntent = this.helper.createQName(element.getAttribute("provides"), reader);
            IntentMap intentMap = new IntentMap(providedIntent);
            if (intentMaps.contains(intentMap)) {
                DuplicateIntentMap error = new DuplicateIntentMap("Duplicate intent map defined for " + providedIntent, startLocation, intentMap);
                context.addError((ValidationFailure)error);
            } else {
                intentMaps.add(intentMap);
            }
            NodeList intentMapQualifiers = element.getElementsByTagName("qualifier");
            for (int n = 0; n < intentMapQualifiers.getLength(); ++n) {
                Node qualifierNode = intentMapQualifiers.item(n);
                if (!(qualifierNode instanceof Element)) continue;
                Element qualifier = (Element)qualifierNode;
                String qualifierName = qualifier.getAttribute("name");
                Element qualifierContents = null;
                NodeList childNodes = qualifier.getChildNodes();
                for (int n2 = 0; n2 < childNodes.getLength(); ++n2) {
                    if (!(childNodes.item(n2) instanceof Element)) continue;
                    qualifierContents = (Element)childNodes.item(n2);
                    break;
                }
                IntentQualifier intentQualifier = new IntentQualifier(qualifierName, qualifierContents);
                intentMap.addQualifier(intentQualifier);
            }
        }
        catch (InvalidPrefixException e) {
            this.raiseInvalidPrefix(startLocation, context, e);
        }
    }

    private void parsePolicyReference(Element element, Set<QName> policySetReferences, XMLStreamReader reader, Location location, IntrospectionContext context) {
        try {
            QName referenceName = this.helper.createQName(element.getAttribute("name"), reader);
            if (referenceName == null) {
                MissingAttribute error = new MissingAttribute("Policy reference must have a name", location, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            } else {
                policySetReferences.add(referenceName);
            }
        }
        catch (InvalidPrefixException e) {
            this.raiseInvalidPrefix(location, context, e);
        }
    }

    private PolicyPhase parsePhase(Element extension, XMLStreamReader reader, IntrospectionContext context) {
        PolicyPhase phase = PolicyPhase.PROVIDED;
        if (extension != null && "urn:fabric3.org".equals(extension.getNamespaceURI())) {
            String phaseAttr = extension.getAttributeNS("urn:fabric3.org", "phase");
            if (phaseAttr != null && phaseAttr.length() > 0) {
                try {
                    phase = PolicyPhase.valueOf((String)phaseAttr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    Location location = reader.getLocation();
                    UnrecognizedAttribute failure = new UnrecognizedAttribute("Invalid phase: " + phaseAttr, location, new ModelObject[0]);
                    context.addError((ValidationFailure)failure);
                    phase = PolicyPhase.INTERCEPTION;
                }
            } else {
                phase = PolicyPhase.INTERCEPTION;
            }
        }
        return phase;
    }

    private void raiseInvalidPrefix(Location location, IntrospectionContext context, InvalidPrefixException e) {
        String prefix = e.getPrefix();
        URI uri = context.getContributionUri();
        InvalidQNamePrefix failure = new InvalidQNamePrefix("The prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", location);
        context.addError((ValidationFailure)failure);
    }

    private void validate(PolicySet policySet, Location location, IntrospectionContext context) {
        for (IntentMap intentMap : policySet.getIntentMaps()) {
            if (policySet.doesProvide(intentMap.getProvides())) continue;
            InvalidValue error = new InvalidValue("Provides on intent map " + intentMap.getProvides() + " does not match a provides entry on the parent policy set: " + policySet.getName(), location, new ModelObject[0]);
            context.addError((ValidationFailure)error);
        }
    }
}

