/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.IntentType;
import org.fabric3.api.model.type.definitions.Qualifier;
import org.fabric3.introspection.xml.definitions.DefinitionsLoader;
import org.fabric3.introspection.xml.definitions.DuplicateDefaultIntent;
import org.fabric3.introspection.xml.definitions.DuplicateQualifiedName;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.oasisopen.sca.annotation.Reference;

public class IntentLoader
extends AbstractValidatingTypeLoader<Intent> {
    private static final QName QUALIFIER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "qualifier");
    private LoaderHelper helper;

    public IntentLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.addAttributes(new String[]{"name", "constrains", "requires", "excludes", "intentType", "appliesTo", "mutuallyExclusive"});
    }

    public Intent load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Set excludes;
        Set requires;
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        QName qName = LoaderUtil.getQName((String)name, (String)context.getTargetNamespace(), (NamespaceContext)reader.getNamespaceContext());
        if (name != null && name.contains(".")) {
            InvalidValue error = new InvalidValue("Profile intent names cannot contain a '.':" + qName, startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
        }
        String constrainsVal = reader.getAttributeValue(null, "constrains");
        QName constrains = null;
        if (constrainsVal != null) {
            try {
                constrains = this.helper.createQName(constrainsVal, reader);
            }
            catch (InvalidPrefixException e) {
                String prefix = e.getPrefix();
                URI uri = context.getContributionUri();
                InvalidQNamePrefix failure = new InvalidQNamePrefix("The prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", startLocation);
                context.addError((ValidationFailure)failure);
                return null;
            }
        }
        IntentType intentType = IntentType.INTERACTION;
        String intentTypeVal = reader.getAttributeValue(null, "intentType");
        if (intentTypeVal != null) {
            try {
                intentType = IntentType.valueOf((String)intentTypeVal.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                UnrecognizedAttribute failure = new UnrecognizedAttribute("Unknown intentType value: " + intentTypeVal, startLocation, new ModelObject[0]);
                context.addError((ValidationFailure)failure);
                return null;
            }
        }
        try {
            requires = this.helper.parseListOfQNames(reader, "requires");
        }
        catch (InvalidPrefixException e) {
            String prefix = e.getPrefix();
            URI uri = context.getContributionUri();
            InvalidQNamePrefix failure = new InvalidQNamePrefix("The requires prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
        boolean mutuallyExclusive = Boolean.parseBoolean(reader.getAttributeValue(null, "mutuallyExclusive"));
        try {
            excludes = this.helper.parseListOfQNames(reader, "excludes");
        }
        catch (InvalidPrefixException e) {
            String prefix = e.getPrefix();
            URI uri = context.getContributionUri();
            InvalidQNamePrefix failure = new InvalidQNamePrefix("The excludes prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
        HashSet<Qualifier> qualifiers = new HashSet<Qualifier>();
        Intent intent = new Intent(qName, constrains, requires, qualifiers, mutuallyExclusive, excludes, intentType, false);
        this.validateAttributes(reader, context, new ModelObject[]{intent});
        boolean defaultSet = false;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Qualifier qualifier;
                    if (!QUALIFIER.equals(reader.getName())) break;
                    Location location = reader.getLocation();
                    String nameAttr = reader.getAttributeValue(null, "name");
                    if (nameAttr == null) {
                        context.addError((ValidationFailure)new MissingAttribute("Qualifier name not specified", location, new ModelObject[0]));
                        return null;
                    }
                    String defaultStr = reader.getAttributeValue(null, "default");
                    Boolean isDefault = Boolean.valueOf(defaultStr);
                    if (isDefault.booleanValue()) {
                        if (defaultSet) {
                            DuplicateDefaultIntent error = new DuplicateDefaultIntent("More than one qualified intent is specified as the default for: " + qName, location, (ModelObject)intent);
                            context.addError((ValidationFailure)error);
                        } else {
                            defaultSet = true;
                        }
                    }
                    if (qualifiers.contains(qualifier = new Qualifier(nameAttr, isDefault.booleanValue()))) {
                        DuplicateQualifiedName error = new DuplicateQualifiedName("Duplicate qualified intent specified for:" + qName, location, (ModelObject)intent);
                        context.addError((ValidationFailure)error);
                        break;
                    }
                    qualifiers.add(qualifier);
                    break;
                }
                case 2: {
                    if (!DefinitionsLoader.INTENT.equals(reader.getName())) break;
                    return new Intent(qName, constrains, requires, qualifiers, mutuallyExclusive, excludes, intentType, false);
                }
            }
        }
    }
}

