/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.net.URI;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.definitions.ImplementationType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ImplementationTypeLoader
extends AbstractValidatingTypeLoader<ImplementationType> {
    private static final QName QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementationType");
    private LoaderRegistry registry;
    private LoaderHelper helper;

    public ImplementationTypeLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper helper) {
        this.registry = registry;
        this.helper = helper;
        this.addAttributes(new String[]{"name", "alwaysProvides", "mayProvide", "type"});
    }

    @Init
    public void init() {
        this.registry.registerLoader(QNAME, (TypeLoader)this);
    }

    public ImplementationType load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        try {
            InvalidValue error;
            String name = reader.getAttributeValue(null, "name");
            if (name == null && (name = reader.getAttributeValue(null, "type")) == null) {
                MissingAttribute error2 = new MissingAttribute("Implementation type name not specified", startLocation, new ModelObject[0]);
                context.addError((ValidationFailure)error2);
                return null;
            }
            NamespaceContext namespaceContext = reader.getNamespaceContext();
            QName qName = LoaderUtil.getQName((String)name, (String)context.getTargetNamespace(), (NamespaceContext)namespaceContext);
            if (!"urn:fabric3.org".equals(qName.getNamespaceURI()) && !this.registry.isRegistered(qName)) {
                error = new InvalidValue("Unknown implementation type: " + qName, startLocation, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            } else if (!qName.getLocalPart().startsWith("implementation.")) {
                error = new InvalidValue("Invalid implementation value: " + qName, startLocation, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
            Set alwaysProvides = this.helper.parseListOfQNames(reader, "alwaysProvides");
            Set mayProvide = this.helper.parseListOfQNames(reader, "mayProvide");
            ImplementationType implementationType = new ImplementationType(qName, alwaysProvides, mayProvide);
            this.validateAttributes(reader, context, new ModelObject[]{implementationType});
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return implementationType;
        }
        catch (InvalidPrefixException e) {
            String prefix = e.getPrefix();
            URI uri = context.getContributionUri();
            InvalidQNamePrefix failure = new InvalidQNamePrefix("The prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
    }
}

