/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.net.URI;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.definitions.ExternalAttachment;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ExternalAttachmentLoader
extends AbstractValidatingTypeLoader<ExternalAttachment> {
    private final LoaderHelper helper;

    public ExternalAttachmentLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.addAttributes(new String[]{"intents", "policySets", "attachTo"});
    }

    public ExternalAttachment load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        try {
            Set intents = this.helper.parseListOfQNames(reader, "intents");
            Set policySets = this.helper.parseListOfQNames(reader, "policySets");
            String attachTo = reader.getAttributeValue(null, "attachTo");
            if (attachTo == null) {
                context.addError((ValidationFailure)new MissingAttribute("Attribute attachTo must be specified", startLocation, new ModelObject[0]));
                attachTo = "";
            }
            ExternalAttachment attachment = new ExternalAttachment(attachTo, policySets, intents);
            this.validateAttributes(reader, context, new ModelObject[]{attachment});
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return attachment;
        }
        catch (InvalidPrefixException e) {
            String prefix = e.getPrefix();
            URI uri = context.getContributionUri();
            InvalidQNamePrefix failure = new InvalidQNamePrefix("The prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
    }
}

