/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.definitions.AbstractPolicyDefinition;
import org.fabric3.api.model.type.definitions.BindingType;
import org.fabric3.api.model.type.definitions.ExternalAttachment;
import org.fabric3.api.model.type.definitions.ImplementationType;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.IntentType;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.api.model.type.definitions.Qualifier;
import org.fabric3.introspection.xml.definitions.DuplicatePolicyDefinition;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoader;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoaderRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DefinitionsLoader
implements XmlResourceElementLoader {
    static final QName INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "intent");
    static final QName POLICY_SET = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "policySet");
    static final QName BINDING_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "bindingType");
    static final QName IMPLEMENTATION_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementationType");
    static final QName DEFINITIONS = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "definitions");
    static final QName EXTERNAL_ATTACHMENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "externalAttachment");
    private XmlResourceElementLoaderRegistry elementLoaderRegistry;
    private Loader loaderRegistry;

    public DefinitionsLoader(@Reference XmlResourceElementLoaderRegistry elementLoaderRegistry, @Reference Loader loader) {
        this.elementLoaderRegistry = elementLoaderRegistry;
        this.loaderRegistry = loader;
    }

    @Init
    public void init() {
        this.elementLoaderRegistry.register((XmlResourceElementLoader)this);
    }

    public QName getType() {
        return DEFINITIONS;
    }

    public void load(XMLStreamReader reader, Resource resource, IntrospectionContext context) throws InstallException, XMLStreamException {
        this.validateAttributes(reader, context);
        ArrayList<AbstractPolicyDefinition> definitions = new ArrayList<AbstractPolicyDefinition>();
        String oldNamespace = context.getTargetNamespace();
        String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
        context.setTargetNamespace(targetNamespace);
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    QName qname = reader.getName();
                    AbstractPolicyDefinition definition = null;
                    if (INTENT.equals(qname)) {
                        definition = (AbstractPolicyDefinition)this.loaderRegistry.load(reader, Intent.class, context);
                    } else if (POLICY_SET.equals(qname)) {
                        definition = (AbstractPolicyDefinition)this.loaderRegistry.load(reader, PolicySet.class, context);
                    } else if (BINDING_TYPE.equals(qname)) {
                        definition = (AbstractPolicyDefinition)this.loaderRegistry.load(reader, BindingType.class, context);
                    } else if (IMPLEMENTATION_TYPE.equals(qname)) {
                        definition = (AbstractPolicyDefinition)this.loaderRegistry.load(reader, ImplementationType.class, context);
                    } else if (EXTERNAL_ATTACHMENT.equals(qname)) {
                        definition = (AbstractPolicyDefinition)this.loaderRegistry.load(reader, ExternalAttachment.class, context);
                    } else {
                        UnrecognizedElement failure = new UnrecognizedElement(reader, location, new ModelObject[0]);
                        context.addError((ValidationFailure)failure);
                    }
                    if (definition == null) break;
                    if (definitions.contains(definition)) {
                        QName name = definition.getName();
                        DuplicatePolicyDefinition error = new DuplicatePolicyDefinition("Duplicate policy definition: " + name, location);
                        context.addError((ValidationFailure)error);
                    }
                    definitions.add(definition);
                    break;
                }
                case 2: {
                    for (AbstractPolicyDefinition candidate : definitions) {
                        if (candidate instanceof ExternalAttachment) {
                            QNameSymbol symbol = new QNameSymbol(candidate.getName());
                            ResourceElement element = new ResourceElement((Symbol)symbol);
                            element.setValue((Object)candidate);
                            resource.addResourceElement(element);
                            continue;
                        }
                        boolean found = false;
                        for (ResourceElement element : resource.getResourceElements()) {
                            QNameSymbol candidateSymbol = new QNameSymbol(candidate.getName());
                            if (!element.getSymbol().equals((Object)candidateSymbol)) continue;
                            element.setValue((Object)candidate);
                            found = true;
                        }
                        if (!found) {
                            String id = candidate.toString();
                            throw new AssertionError((Object)("Definition not found: " + id));
                        }
                        if (!(candidate instanceof Intent)) continue;
                        this.expandQualifiers((Intent)candidate, resource);
                    }
                    context.setTargetNamespace(oldNamespace);
                    return;
                }
            }
        }
    }

    private void expandQualifiers(Intent intent, Resource resource) {
        String ns = intent.getName().getNamespaceURI();
        String localPart = intent.getName().getLocalPart();
        for (Qualifier qualifier : intent.getQualifiers()) {
            QName qualifierName = new QName(ns, localPart + "." + qualifier.getName());
            QName constrains = intent.getConstrains();
            Set requires = intent.getRequires();
            IntentType intentType = intent.getIntentType();
            boolean isDefault = qualifier.isDefault();
            HashSet<QName> excludes = new HashSet<QName>(intent.getExcludes());
            if (intent.isMutuallyExclusive()) {
                for (Qualifier entry : intent.getQualifiers()) {
                    if (entry == qualifier) continue;
                    excludes.add(new QName(ns, localPart + "." + entry.getName()));
                }
            }
            Intent qualified = new Intent(qualifierName, constrains, requires, Collections.emptySet(), false, excludes, intentType, isDefault);
            QNameSymbol symbol = new QNameSymbol(qualifierName);
            ResourceElement element = new ResourceElement((Symbol)symbol);
            element.setValue((Object)qualified);
            resource.addResourceElement(element);
        }
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("targetNamespace".equals(name)) continue;
            UnrecognizedAttribute failure = new UnrecognizedAttribute(name, location, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
        }
    }
}

