/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.net.URI;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.definitions.BindingType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class BindingTypeLoader
extends AbstractValidatingTypeLoader<BindingType> {
    private final LoaderHelper helper;

    public BindingTypeLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.addAttributes(new String[]{"name", "type", "alwaysProvides", "mayProvide"});
    }

    public BindingType load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            name = reader.getAttributeValue(null, "type");
        }
        QName qName = LoaderUtil.getQName((String)name, (String)context.getTargetNamespace(), (NamespaceContext)reader.getNamespaceContext());
        try {
            Set alwaysProvides = this.helper.parseListOfQNames(reader, "alwaysProvides");
            Set mayProvide = this.helper.parseListOfQNames(reader, "mayProvide");
            BindingType bindingType = new BindingType(qName, alwaysProvides, mayProvide);
            this.validateAttributes(reader, context, new ModelObject[]{bindingType});
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return bindingType;
        }
        catch (InvalidPrefixException e) {
            String prefix = e.getPrefix();
            URI uri = context.getContributionUri();
            InvalidQNamePrefix failure = new InvalidQNamePrefix("The prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
    }
}

