/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Target;
import org.fabric3.api.model.type.component.WireDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidTargetException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class WireLoader
extends AbstractValidatingTypeLoader<WireDefinition> {
    private LoaderHelper helper;
    private boolean roundTrip;

    public WireLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.addAttributes(new String[]{"source", "target", "requires", "replace"});
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:loader/@round.trip")
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    public WireDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String referenceAttribute = reader.getAttributeValue(null, "source");
        String serviceAttribute = reader.getAttributeValue(null, "target");
        String replaceAttribute = reader.getAttributeValue(null, "replace");
        boolean replace = Boolean.parseBoolean(replaceAttribute);
        Target referenceTarget = null;
        Target serviceTarget = null;
        try {
            referenceTarget = this.helper.parseTarget(referenceAttribute, reader);
            serviceTarget = this.helper.parseTarget(serviceAttribute, reader);
        }
        catch (InvalidTargetException e) {
            InvalidValue failure = new InvalidValue("Invalid wire attribute", startLocation, (Throwable)e, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
        }
        WireDefinition definition = new WireDefinition(referenceTarget, serviceTarget, replace);
        if (this.roundTrip) {
            definition.enableRoundTrip();
            if (referenceAttribute != null) {
                definition.attributeSpecified("source");
            }
            if (serviceAttribute != null) {
                definition.attributeSpecified("target");
            }
            if (replaceAttribute != null) {
                definition.attributeSpecified("replace");
            }
        }
        this.validateAttributes(reader, context, new ModelObject[]{definition});
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        return definition;
    }
}

