/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URL;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Include;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.composite.InvalidInclude;
import org.fabric3.introspection.xml.composite.MissingComposite;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.ElementLoadFailure;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;

public class IncludeLoader
extends AbstractExtensibleTypeLoader<Include> {
    private static final QName INCLUDE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "include");
    private MetaDataStore store;

    public IncludeLoader(LoaderRegistry registry) {
        this(registry, null);
    }

    @Constructor
    public IncludeLoader(@Reference LoaderRegistry registry, @Reference(required=false) MetaDataStore store) {
        super(registry);
        this.store = store;
        this.addAttributes(new String[]{"name", "scdlResource", "requires"});
    }

    @Override
    public QName getXMLType() {
        return INCLUDE;
    }

    public Include load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String nameAttr = reader.getAttributeValue(null, "name");
        if (nameAttr == null || nameAttr.length() == 0) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            return null;
        }
        QName name = LoaderUtil.getQName((String)nameAttr, (String)context.getTargetNamespace(), (NamespaceContext)reader.getNamespaceContext());
        String scdlResource = reader.getAttributeValue(null, "scdlResource");
        Include include = new Include();
        this.validateAttributes(reader, context, new ModelObject[]{include});
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        ClassLoader cl = context.getClassLoader();
        URI contributionUri = context.getContributionUri();
        if (scdlResource != null) {
            URL url = cl.getResource(scdlResource);
            if (url == null) {
                include.setName(name);
                MissingComposite failure = new MissingComposite("Composite file not found: " + scdlResource, startLocation, (ModelObject)include);
                context.addError((ValidationFailure)failure);
                return include;
            }
            this.loadFromSideFile(include, name, cl, contributionUri, url, reader, context);
            return include;
        }
        if (this.store == null) {
            throw new UnsupportedOperationException("scdlLocation or scdlResource must be supplied as no MetaDataStore is available");
        }
        try {
            QNameSymbol symbol = new QNameSymbol(name);
            include.setName(name);
            ResourceElement element = this.store.resolve(contributionUri, Composite.class, (Symbol)symbol, context);
            if (element == null) {
                String id = name.toString();
                MissingComposite failure = new MissingComposite("Composite not found: " + id, startLocation, (ModelObject)include);
                context.addError((ValidationFailure)failure);
                URI uri = context.getContributionUri();
                Composite pointer = new Composite(name, true, uri);
                include.setIncluded(pointer);
                return include;
            }
            Composite composite = (Composite)element.getValue();
            include.setIncluded(composite);
            return include;
        }
        catch (StoreException e) {
            ElementLoadFailure failure = new ElementLoadFailure("Error loading element", (Throwable)e, startLocation);
            context.addError((ValidationFailure)failure);
            return include;
        }
    }

    private void loadFromSideFile(Include include, QName name, ClassLoader cl, URI contributionUri, URL url, XMLStreamReader reader, IntrospectionContext context) {
        Composite composite;
        DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(contributionUri, cl, url);
        Location startLocation = reader.getLocation();
        try {
            UrlSource source = new UrlSource(url);
            composite = (Composite)this.registry.load((Source)source, Composite.class, (IntrospectionContext)childContext);
        }
        catch (LoaderException e) {
            InvalidInclude failure = new InvalidInclude("Error loading include: " + name, e, startLocation, new ModelObject[]{include});
            context.addError((ValidationFailure)failure);
            return;
        }
        if (childContext.hasErrors()) {
            context.addErrors(childContext.getErrors());
        }
        if (childContext.hasWarnings()) {
            context.addWarnings(childContext.getWarnings());
        }
        include.setName(name);
        include.setScdlLocation(url);
        include.setIncluded(composite);
    }
}

