/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.CompositeService;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.composite.MissingPromotion;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class CompositeServiceLoader
extends AbstractValidatingTypeLoader<CompositeService> {
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private LoaderRegistry registry;
    private LoaderHelper loaderHelper;
    private boolean roundTrip;

    public CompositeServiceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        this.registry = registry;
        this.loaderHelper = loaderHelper;
        this.addAttributes(new String[]{"name", "requires", "promote", "policySets"});
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:loader/@round.trip")
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    public CompositeService load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Service name not specified", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            return null;
        }
        CompositeService service = new CompositeService(name);
        URI uri = this.parsePromote(service, reader, startLocation, context);
        service.setPromote(uri);
        if (this.roundTrip) {
            service.enableRoundTrip();
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)service, reader, context);
        this.validateAttributes(reader, context, new ModelObject[]{service});
        boolean callback = false;
        while (true) {
            int i = reader.next();
            switch (i) {
                case 1: {
                    Location location = reader.getLocation();
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    ModelObject type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof ServiceContract) {
                        service.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof BindingDefinition)) {
                            if (type == null) break;
                            context.addError((ValidationFailure)new UnrecognizedElement(reader, location, new ModelObject[]{service}));
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, service.getCallbackBindings(), location, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, service.getCallbackBindings(), location, context)) {
                                service.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, service.getBindings(), location, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, service.getBindings(), location, context)) {
                                service.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return service;
                }
            }
        }
    }

    private URI parsePromote(CompositeService service, XMLStreamReader reader, Location startLocation, IntrospectionContext context) {
        URI uri;
        String name = service.getName();
        String promote = reader.getAttributeValue(null, "promote");
        if (promote == null) {
            MissingPromotion error = new MissingPromotion("Promotion not specified on composite service " + name, startLocation, (ModelObject)service);
            context.addError((ValidationFailure)error);
        }
        try {
            uri = this.loaderHelper.parseUri(promote);
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid promote URI specified on service " + name, startLocation, (Throwable)e, new ModelObject[]{service});
            context.addError((ValidationFailure)error);
            uri = URI.create("");
        }
        if (uri == null) {
            InvalidValue error = new InvalidValue("Empty promote URI specified on service " + name, startLocation, new ModelObject[]{service});
            context.addError((ValidationFailure)error);
            uri = URI.create("");
        }
        return uri;
    }
}

