/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ChannelDefinition;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.composite.IllegalBinding;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.ChannelTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ChannelLoader
extends AbstractExtensibleTypeLoader<ChannelDefinition> {
    private static final QName CHANNEL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "channel");
    private LoaderHelper loaderHelper;
    private boolean roundTrip;
    private Map<String, ChannelTypeLoader> channelTypeLoaders = Collections.emptyMap();

    public ChannelLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        super(registry);
        this.addAttributes(new String[]{"name", "requires", "type", "local"});
        this.loaderHelper = loaderHelper;
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:loader/@round.trip")
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    @Reference(required=false)
    public void setChannelTypeLoaders(Map<String, ChannelTypeLoader> channelTypeLoaders) {
        this.channelTypeLoaders = channelTypeLoaders;
        for (ChannelTypeLoader channelTypeLoader : channelTypeLoaders.values()) {
            this.addAttributes(channelTypeLoader.getAttributes());
        }
    }

    public ChannelDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ChannelTypeLoader channelTypeLoader;
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Component name not specified", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            return null;
        }
        URI uri = context.getContributionUri();
        String channelType = reader.getAttributeValue(null, "type");
        if (channelType == null) {
            channelType = "default";
        }
        boolean local = Boolean.parseBoolean(reader.getAttributeValue(null, "local"));
        ChannelDefinition definition = new ChannelDefinition(name, uri, channelType, local);
        this.validateAttributes(reader, context, new ModelObject[]{definition});
        if (this.roundTrip) {
            definition.enableRoundTrip();
        }
        if ((channelTypeLoader = this.channelTypeLoaders.get(channelType)) == null) {
            context.addError((ValidationFailure)new InvalidValue("Invalid channel type", startLocation, new ModelObject[]{definition}));
        } else {
            channelTypeLoader.load(definition, reader, context);
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    QName elementName = reader.getName();
                    ModelObject type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof BindingDefinition) {
                        if (local) {
                            context.addError((ValidationFailure)new IllegalBinding("Bindings cannot be configured on a local channel: " + name, location, (ModelObject)definition));
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        boolean check = BindingHelper.checkDuplicateNames(binding, definition.getBindings(), location, context);
                        if (check) {
                            definition.addBinding(binding);
                        }
                    } else {
                        if (type == null) break;
                        context.addError((ValidationFailure)new UnrecognizedElement(reader, location, new ModelObject[]{definition}));
                        break;
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                }
                case 2: {
                    QName elementName = reader.getName();
                    if (!CHANNEL.equals(elementName)) break;
                    return definition;
                }
            }
        }
    }

    @Override
    public QName getXMLType() {
        return CHANNEL;
    }
}

