/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.componentType;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.component.ServiceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.common.MissingReferenceName;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ComponentTypeLoader
implements TypeLoader<ComponentType> {
    private static final QName COMPONENT_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "componentType");
    private static final QName PROPERTY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "property");
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service");
    private static final QName REFERENCE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "reference");
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private LoaderHelper loaderHelper;
    private final LoaderRegistry registry;
    private final TypeLoader<Property> propertyLoader;

    public ComponentTypeLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper, @Reference(name="property") TypeLoader<Property> propertyLoader) {
        this.registry = registry;
        this.loaderHelper = loaderHelper;
        this.propertyLoader = propertyLoader;
    }

    @Init
    public void init() {
        this.registry.registerLoader(COMPONENT_TYPE, (TypeLoader)this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregisterLoader(COMPONENT_TYPE);
    }

    public QName getXMLType() {
        return COMPONENT_TYPE;
    }

    public ComponentType load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        ComponentType type = new ComponentType();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    QName qname = reader.getName();
                    if (PROPERTY.equals(qname)) {
                        Property property = (Property)this.propertyLoader.load(reader, introspectionContext);
                        type.add(property);
                        break;
                    }
                    if (SERVICE.equals(qname)) {
                        ServiceDefinition service = this.loadService(reader, introspectionContext);
                        type.add(service);
                        break;
                    }
                    if (REFERENCE.equals(qname)) {
                        ReferenceDefinition reference = this.loadReference(reader, introspectionContext);
                        type.add(reference);
                        break;
                    }
                    ModelObject modelObject = (ModelObject)this.registry.load(reader, ModelObject.class, introspectionContext);
                    if (modelObject instanceof Property) {
                        type.add((Property)modelObject);
                        break;
                    }
                    if (modelObject instanceof ServiceDefinition) {
                        type.add((ServiceDefinition)modelObject);
                        break;
                    }
                    if (modelObject instanceof ReferenceDefinition) {
                        type.add((ReferenceDefinition)modelObject);
                        break;
                    }
                    if (modelObject == null) break;
                    UnrecognizedElement failure = new UnrecognizedElement(reader, location, new ModelObject[]{type});
                    introspectionContext.addError((ValidationFailure)failure);
                    break;
                }
                case 2: {
                    return type;
                }
            }
        }
    }

    private ServiceDefinition loadService(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            return null;
        }
        ServiceDefinition service = new ServiceDefinition(name, null);
        this.validateServiceAttributes(reader, service, context);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)service, reader, context);
        boolean callback = false;
        while (true) {
            int i = reader.next();
            switch (i) {
                case 1: {
                    Location location = reader.getLocation();
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    ModelObject type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof ServiceContract) {
                        service.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof BindingDefinition)) {
                            if (type == null) break;
                            UnrecognizedElement failure = new UnrecognizedElement(reader, location, new ModelObject[]{service});
                            context.addError((ValidationFailure)failure);
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, service.getCallbackBindings(), location, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, service.getCallbackBindings(), location, context)) {
                                service.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, service.getBindings(), location, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, service.getBindings(), location, context)) {
                                service.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return service;
                }
            }
        }
    }

    private ReferenceDefinition loadReference(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingReferenceName failure = new MissingReferenceName(startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
        ReferenceDefinition reference = new ReferenceDefinition(name);
        String value = reader.getAttributeValue(null, "multiplicity");
        Multiplicity multiplicity = Multiplicity.ONE_ONE;
        try {
            if (value != null) {
                multiplicity = Multiplicity.fromString((String)value);
            }
        }
        catch (IllegalArgumentException e) {
            InvalidValue failure = new InvalidValue("Invalid multiplicity value: " + value, startLocation, new ModelObject[]{reference});
            context.addError((ValidationFailure)failure);
        }
        reference.setMultiplicity(multiplicity);
        this.validateReferenceAttributes(reader, reference, context);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)reference, reader, context);
        boolean callback = false;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    ModelObject type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof ServiceContract) {
                        reference.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof BindingDefinition)) {
                            if (type == null) break;
                            context.addError((ValidationFailure)new UnrecognizedElement(reader, location, new ModelObject[]{reference}));
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, reference.getCallbackBindings(), startLocation, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, reference.getCallbackBindings(), startLocation, context)) {
                                reference.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, reference.getBindings(), startLocation, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, reference.getBindings(), startLocation, context)) {
                                reference.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return reference;
                }
            }
        }
    }

    private void validateReferenceAttributes(XMLStreamReader reader, ReferenceDefinition reference, IntrospectionContext context) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("name".equals(name) || "requires".equals(name) || "policySets".equals(name) || "multiplicity".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, location, new ModelObject[]{reference}));
        }
    }

    private void validateServiceAttributes(XMLStreamReader reader, ServiceDefinition service, IntrospectionContext context) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("name".equals(name) || "requires".equals(name) || "policySets".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, location, new ModelObject[]{service}));
        }
    }
}

