/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.introspection.xml.common.InvalidAttributes;
import org.fabric3.introspection.xml.common.InvalidPropertyValue;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;

public class PropertyLoader
extends AbstractValidatingTypeLoader<org.fabric3.api.model.type.component.Property> {
    private static final String NAME = "name";
    private static final String MANY = "many";
    private static final String MUST_SUPPLY = "mustSupply";
    private static final String TYPE = "type";
    private static final String ELEMENT = "element";
    private static final String SOURCE = "source";
    private static final String VALUE = "value";
    private LoaderHelper helper;
    private boolean roundTrip;

    public PropertyLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.addAttributes(new String[]{NAME, MANY, MUST_SUPPLY, TYPE, SOURCE, ELEMENT, VALUE});
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:loader/@round.trip")
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    public org.fabric3.api.model.type.component.Property load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        InvalidPropertyValue error;
        InvalidAttributes error2;
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, NAME);
        String manyAttr = reader.getAttributeValue(null, MANY);
        boolean many = Boolean.parseBoolean(manyAttr);
        String mustSupplyAttr = reader.getAttributeValue(null, MUST_SUPPLY);
        boolean mustSupply = Boolean.parseBoolean(mustSupplyAttr);
        String typeAttribute = reader.getAttributeValue(null, TYPE);
        String elementAttribute = reader.getAttributeValue(null, ELEMENT);
        org.fabric3.api.model.type.component.Property property = new org.fabric3.api.model.type.component.Property(name);
        this.validateAttributes(reader, context, new ModelObject[]{property});
        if (typeAttribute != null && elementAttribute != null) {
            InvalidAttributes error3 = new InvalidAttributes("Cannot specify both type and element attributes for a property", startLocation, (ModelObject)property);
            context.addError((ValidationFailure)error3);
        }
        QName type = null;
        QName element = null;
        if (typeAttribute != null) {
            try {
                type = this.helper.createQName(typeAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                error2 = new InvalidAttributes("Invalid property type namespace:" + e.getMessage(), startLocation, (ModelObject)property);
                context.addError((ValidationFailure)error2);
            }
        } else if (elementAttribute != null) {
            try {
                element = this.helper.createQName(elementAttribute, reader);
            }
            catch (InvalidPrefixException e) {
                error2 = new InvalidAttributes("Invalid property element namespace:" + e.getMessage(), startLocation, (ModelObject)property);
                context.addError((ValidationFailure)error2);
            }
        }
        String valueAttribute = reader.getAttributeValue(null, VALUE);
        Document value = this.helper.loadPropertyValues(reader);
        if (valueAttribute != null && value.getDocumentElement().getChildNodes().getLength() > 0) {
            error = new InvalidPropertyValue("Property value configured using the value attribute and inline: " + name, startLocation, (ModelObject)property);
            context.addError((ValidationFailure)error);
        }
        if (this.roundTrip) {
            property.enableRoundTrip();
            if (manyAttr != null) {
                property.attributeSpecified(MANY);
            }
            if (mustSupplyAttr != null) {
                property.attributeSpecified(MUST_SUPPLY);
            }
            if (typeAttribute != null) {
                property.attributeSpecified(TYPE);
            }
            if (elementAttribute != null) {
                property.attributeSpecified(ELEMENT);
            }
            if (valueAttribute != null) {
                property.attributeSpecified(VALUE);
            }
        }
        property.setRequired(mustSupply);
        property.setType(type);
        property.setElement(element);
        property.setMany(many);
        if (!many && value.getDocumentElement().getChildNodes().getLength() > 1) {
            error = new InvalidPropertyValue("A single-valued property is configured with multiple values: " + name, startLocation, (ModelObject)property);
            context.addError((ValidationFailure)error);
        } else {
            if (valueAttribute != null) {
                value = this.helper.loadPropertyValue(valueAttribute);
            }
            property.setDefaultValue(value);
        }
        return property;
    }
}

