/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.ImplementationNotFoundException;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.ResourceNotFound;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class JavaInterfaceLoader
extends AbstractValidatingTypeLoader<ServiceContract> {
    private final JavaContractProcessor contractProcessor;
    private final IntrospectionHelper helper;

    public JavaInterfaceLoader(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        this.contractProcessor = contractProcessor;
        this.helper = helper;
        this.addAttributes(new String[]{"interface", "callbackInterface"});
    }

    public ServiceContract load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Class callbackClass;
        Class interfaceClass;
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "interface");
        if (name == null) {
            JavaServiceContract contract = new JavaServiceContract();
            MissingAttribute failure = new MissingAttribute("An interface must be specified using the class attribute", startLocation, new ModelObject[]{contract});
            context.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return contract;
        }
        try {
            interfaceClass = this.helper.loadClass(name, context.getClassLoader());
        }
        catch (ImplementationNotFoundException e) {
            ResourceNotFound failure = new ResourceNotFound("Interface not found: " + name, startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return null;
        }
        JavaServiceContract serviceContract = this.contractProcessor.introspect(interfaceClass, context, new ModelObject[0]);
        this.validateAttributes(reader, context, new ModelObject[]{serviceContract});
        name = reader.getAttributeValue(null, "callbackInterface");
        try {
            callbackClass = name != null ? this.helper.loadClass(name, context.getClassLoader()) : null;
        }
        catch (ImplementationNotFoundException e) {
            ResourceNotFound failure = new ResourceNotFound("Callback interface not found: " + name, startLocation, new ModelObject[]{serviceContract});
            context.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return serviceContract;
        }
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        TypeMapping mapping = context.getTypeMapping(interfaceClass);
        if (mapping == null) {
            mapping = new TypeMapping();
            context.addTypeMapping(interfaceClass, mapping);
        }
        this.helper.resolveTypeParameters(interfaceClass, mapping);
        if (callbackClass != null) {
            this.helper.resolveTypeParameters(callbackClass, mapping);
            JavaServiceContract callbackContract = this.contractProcessor.introspect(callbackClass, context, new ModelObject[0]);
            serviceContract.setCallbackContract((ServiceContract)callbackContract);
        }
        return serviceContract;
    }
}

