/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentService;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class ComponentServiceLoader
extends AbstractExtensibleTypeLoader<ComponentService> {
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service");
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private LoaderHelper loaderHelper;
    private boolean roundTrip;

    public ComponentServiceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        super(registry);
        this.addAttributes(new String[]{"name", "requires", "policySets"});
        this.loaderHelper = loaderHelper;
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:loader/@round.trip")
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    @Override
    public QName getXMLType() {
        return SERVICE;
    }

    /*
     * Unable to fully structure code
     */
    public ComponentService load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        startLocation = reader.getLocation();
        name = reader.getAttributeValue(null, "name");
        if (name == null) {
            failure = new MissingAttribute("Missing name attribute", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            return null;
        }
        definition = new ComponentService(name);
        if (this.roundTrip) {
            definition.enableRoundTrip();
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        this.validateAttributes(reader, context, new ModelObject[]{definition});
        callback = false;
        while (true) {
            i = reader.next();
            switch (i) {
                case 1: {
                    location = reader.getLocation();
                    callback = ComponentServiceLoader.CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    elementName = reader.getName();
                    type = this.registry.load(reader, Object.class, context);
                    if (!(type instanceof ServiceContract)) ** GOTO lbl27
                    definition.setServiceContract((ServiceContract)type);
                    ** GOTO lbl50
lbl27:
                    // 1 sources

                    if (!(type instanceof BindingDefinition)) ** GOTO lbl40
                    binding = (BindingDefinition)type;
                    if (!callback) ** GOTO lbl35
                    if (binding.getName() == null) {
                        BindingHelper.configureName(binding, definition.getCallbackBindings(), location, context);
                    }
                    if (check = BindingHelper.checkDuplicateNames(binding, definition.getCallbackBindings(), location, context)) {
                        definition.addCallbackBinding(binding);
                    }
                    ** GOTO lbl50
lbl35:
                    // 1 sources

                    if (binding.getName() == null) {
                        BindingHelper.configureName(binding, definition.getBindings(), location, context);
                    }
                    if (!(check = BindingHelper.checkDuplicateNames(binding, definition.getBindings(), location, context))) ** GOTO lbl50
                    definition.addBinding(binding);
                    ** GOTO lbl50
lbl40:
                    // 1 sources

                    if (type instanceof QName) {
                        definition.getPolicySets().add((QName)type);
                    } else {
                        if (type == null) {
                            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
                            if (reader.getEventType() != 2 || !reader.getName().getLocalPart().equals("service")) break;
                            return definition;
                        }
                        context.addError((ValidationFailure)new UnrecognizedElement(reader, location, new ModelObject[]{definition}));
                        break;
                    }
lbl50:
                    // 5 sources

                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    if (!ComponentServiceLoader.SERVICE.equals(reader.getName())) break;
                    return definition;
                }
            }
        }
    }
}

