/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.Autowire;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentReference;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.Target;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.common.InvalidBinding;
import org.fabric3.introspection.xml.common.MissingReferenceName;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidTargetException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class ComponentReferenceLoader
extends AbstractExtensibleTypeLoader<ComponentReference> {
    private static final QName REFERENCE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "reference");
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private LoaderHelper loaderHelper;
    private boolean roundTrip;

    public ComponentReferenceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        super(registry);
        this.addAttributes(new String[]{"name", "autowire", "target", "multiplicity", "requires", "policySets", "nonOverridable"});
        this.loaderHelper = loaderHelper;
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:loader/@round.trip")
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    @Override
    public QName getXMLType() {
        return REFERENCE;
    }

    public ComponentReference load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingReferenceName failure = new MissingReferenceName(startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String autowire = reader.getAttributeValue(null, "autowire");
        Multiplicity multiplicity = this.parseMultiplicity(reader, startLocation, context);
        ComponentReference reference = new ComponentReference(name, multiplicity);
        if ("true".equalsIgnoreCase(autowire)) {
            reference.setAutowire(Autowire.ON);
        } else if ("false".equalsIgnoreCase(autowire)) {
            reference.setAutowire(Autowire.OFF);
        }
        String targetAttribute = this.parseTargets(reference, reader, startLocation, context);
        String nonOverridable = reader.getAttributeValue(null, "nonOverridable");
        if (nonOverridable != null) {
            reference.setNonOverridable(Boolean.parseBoolean(nonOverridable));
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)reference, reader, context);
        this.validateAttributes(reader, context, new ModelObject[]{reference});
        if (this.roundTrip) {
            reference.enableRoundTrip();
            if (autowire != null) {
                reference.attributeSpecified("autowire");
            }
            if (targetAttribute != null) {
                reference.attributeSpecified("target");
            }
            if (nonOverridable != null) {
                reference.attributeSpecified("nonOverridable");
            }
        }
        boolean callback = false;
        boolean bindingError = false;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    ModelObject type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof ServiceContract) {
                        reference.setServiceContract((ServiceContract)type);
                    } else if (type instanceof BindingDefinition) {
                        BindingDefinition binding = (BindingDefinition)type;
                        if (!reference.getTargets().isEmpty()) {
                            if (bindingError) break;
                            InvalidBinding error = new InvalidBinding("Bindings cannot be configured when the target attribute on a reference is used: " + name, location, (ModelObject)binding);
                            context.addError((ValidationFailure)error);
                            bindingError = true;
                            break;
                        }
                        this.configureBinding(reference, binding, callback, location, context);
                    } else {
                        if (type == null) break;
                        UnrecognizedElement failure = new UnrecognizedElement(reader, location, new ModelObject[]{reference});
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    if (!REFERENCE.equals(reader.getName())) break;
                    return reference;
                }
            }
        }
    }

    private Multiplicity parseMultiplicity(XMLStreamReader reader, Location location, IntrospectionContext context) {
        String value = reader.getAttributeValue(null, "multiplicity");
        Multiplicity multiplicity = null;
        try {
            if (value != null) {
                multiplicity = Multiplicity.fromString((String)value);
            }
        }
        catch (IllegalArgumentException e) {
            InvalidValue failure = new InvalidValue("Invalid multiplicity value: " + value, location, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
        }
        return multiplicity;
    }

    private String parseTargets(ComponentReference reference, XMLStreamReader reader, Location location, IntrospectionContext context) {
        String targetAttribute = reader.getAttributeValue(null, "target");
        ArrayList<Target> targets = new ArrayList<Target>();
        try {
            if (targetAttribute != null) {
                StringTokenizer tokenizer = new StringTokenizer(targetAttribute);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    Target target = this.loaderHelper.parseTarget(token, reader);
                    targets.add(target);
                }
            }
        }
        catch (InvalidTargetException e) {
            InvalidValue failure = new InvalidValue("Invalid target format", location, (Throwable)e, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
        }
        reference.addTargets(targets);
        return targetAttribute;
    }

    private void configureBinding(ComponentReference reference, BindingDefinition binding, boolean callback, Location location, IntrospectionContext context) {
        if (callback) {
            if (binding.getName() == null) {
                BindingHelper.configureName(binding, reference.getCallbackBindings(), location, context);
            }
            reference.addCallbackBinding(binding);
        } else {
            boolean check;
            if (binding.getName() == null) {
                BindingHelper.configureName(binding, reference.getBindings(), location, context);
            }
            if (check = BindingHelper.checkDuplicateNames(binding, reference.getBindings(), location, context)) {
                reference.addBinding(binding);
            }
        }
    }
}

