/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentProducer;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.common.MissingProducerName;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class ComponentProducerLoader
extends AbstractExtensibleTypeLoader<ComponentProducer> {
    private static final QName PRODUCER = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "producer");
    private boolean roundTrip;

    public ComponentProducerLoader(@Reference LoaderRegistry registry) {
        super(registry);
        this.addAttributes(new String[]{"name", "target"});
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:loader/@round.trip")
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    @Override
    public QName getXMLType() {
        return PRODUCER;
    }

    public ComponentProducer load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingProducerName failure = new MissingProducerName(startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
        String targetAttribute = reader.getAttributeValue(null, "target");
        ComponentProducer producer = new ComponentProducer(name);
        ArrayList<URI> targets = new ArrayList<URI>();
        if (targetAttribute != null) {
            StringTokenizer tokenizer = new StringTokenizer(targetAttribute);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    if (token.startsWith("\\\\")) {
                        token = "domain://" + token.substring(2);
                    }
                    URI target = new URI(token);
                    targets.add(target);
                }
                catch (URISyntaxException e) {
                    InvalidValue failure = new InvalidValue("Invalid target format", startLocation, (Throwable)e, new ModelObject[0]);
                    context.addError((ValidationFailure)failure);
                }
            }
        }
        producer.setTargets(targets);
        this.validateAttributes(reader, context, new ModelObject[]{producer});
        if (this.roundTrip) {
            producer.enableRoundTrip();
            if (targetAttribute != null) {
                producer.attributeSpecified("target");
            }
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Location location = reader.getLocation();
                    QName elementName = reader.getName();
                    ModelObject type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    if (type instanceof ServiceContract) {
                        producer.setServiceContract((ServiceContract)type);
                    } else if (type instanceof BindingDefinition) {
                        BindingDefinition binding = (BindingDefinition)type;
                        boolean check = BindingHelper.checkDuplicateNames(binding, producer.getBindings(), location, context);
                        if (check) {
                            producer.addBinding(binding);
                        }
                    } else {
                        if (type == null) break;
                        context.addError((ValidationFailure)new UnrecognizedElement(reader, location, new ModelObject[]{producer}));
                        break;
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (!PRODUCER.equals(reader.getName())) break;
                    return producer;
                }
            }
        }
    }
}

