/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.common;

import java.util.List;
import javax.xml.stream.Location;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.introspection.xml.common.BindingNameNotConfigured;
import org.fabric3.introspection.xml.common.InvalidBindingName;
import org.fabric3.spi.introspection.IntrospectionContext;

public class BindingHelper {
    public static void configureName(BindingDefinition binding, List<BindingDefinition> bindings, Location location, IntrospectionContext context) {
        String name = binding.getType().getLocalPart();
        if (BindingHelper.searchName(name, bindings)) {
            binding.setName(name);
            BindingNameNotConfigured error = new BindingNameNotConfigured(binding, location);
            context.addError((ValidationFailure)error);
        } else {
            binding.setName(name);
        }
    }

    public static boolean checkDuplicateNames(BindingDefinition binding, List<BindingDefinition> bindings, Location location, IntrospectionContext context) {
        for (BindingDefinition definition : bindings) {
            String bindingName = definition.getName();
            if (!bindingName.equals(binding.getName())) continue;
            InvalidBindingName error = new InvalidBindingName("Duplicate binding named " + bindingName, location, (ModelObject)definition);
            context.addError((ValidationFailure)error);
            return false;
        }
        return true;
    }

    private static boolean searchName(String name, List<BindingDefinition> bindings) {
        for (BindingDefinition entry : bindings) {
            if (!name.equals(entry.getName())) continue;
            return true;
        }
        return false;
    }
}

