/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import org.fabric3.implementation.pojo.spi.reflection.ConsumerInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ConsumerInvokerFactory;
import org.fabric3.implementation.pojo.spi.reflection.InjectorFactory;
import org.fabric3.implementation.pojo.spi.reflection.InstantiatorFactory;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvokerFactory;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvokerFactory;
import org.fabric3.spi.container.objectfactory.Injector;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.oasisopen.sca.annotation.Reference;

public class ReflectionFactoryImpl
implements ReflectionFactory {
    private InstantiatorFactory instantiatorFactory;
    private InjectorFactory injectorFactory;
    private LifecycleInvokerFactory lifecycleInvokerFactory;
    private ServiceInvokerFactory serviceInvokerFactory;
    private ConsumerInvokerFactory consumerInvokerFactory;

    public ReflectionFactoryImpl(@Reference InstantiatorFactory instantiatorFactory, @Reference InjectorFactory injectorFactory, @Reference LifecycleInvokerFactory lifecycleInvokerFactory, @Reference ServiceInvokerFactory serviceInvokerFactory, @Reference ConsumerInvokerFactory consumerInvokerFactory) {
        this.instantiatorFactory = instantiatorFactory;
        this.injectorFactory = injectorFactory;
        this.lifecycleInvokerFactory = lifecycleInvokerFactory;
        this.serviceInvokerFactory = serviceInvokerFactory;
        this.consumerInvokerFactory = consumerInvokerFactory;
    }

    @Reference(required=false)
    public void setInstantiatorFactories(List<InstantiatorFactory> factories) {
        for (InstantiatorFactory factory : factories) {
            if (factory.isDefault() && this.instantiatorFactory != null) continue;
            this.instantiatorFactory = factory;
        }
    }

    @Reference(required=false)
    public void setInjectorFactories(List<InjectorFactory> factories) {
        for (InjectorFactory factory : factories) {
            if (factory.isDefault() && this.injectorFactory != null) continue;
            this.injectorFactory = factory;
        }
    }

    @Reference(required=false)
    public void setLifecycleInvokerFactories(List<LifecycleInvokerFactory> factories) {
        for (LifecycleInvokerFactory factory : factories) {
            if (factory.isDefault() && this.lifecycleInvokerFactory != null) continue;
            this.lifecycleInvokerFactory = factory;
        }
    }

    @Reference(required=false)
    public void setServiceInvokerFactories(List<ServiceInvokerFactory> factories) {
        for (ServiceInvokerFactory factory : factories) {
            if (factory.isDefault() && this.serviceInvokerFactory != null) continue;
            this.serviceInvokerFactory = factory;
        }
    }

    @Reference(required=false)
    public void setConsumerInvokerFactories(List<ConsumerInvokerFactory> factories) {
        for (ConsumerInvokerFactory factory : factories) {
            if (factory.isDefault() && this.serviceInvokerFactory != null) continue;
            this.consumerInvokerFactory = factory;
        }
    }

    @Override
    public <T> ObjectFactory<T> createInstantiator(Constructor<T> constructor, ObjectFactory<?>[] parameterFactories) {
        return this.instantiatorFactory.createInstantiator(constructor, parameterFactories);
    }

    @Override
    public Injector<?> createInjector(Member member, ObjectFactory<?> parameterFactory) {
        return this.injectorFactory.createInjector(member, parameterFactory);
    }

    @Override
    public LifecycleInvoker createLifecycleInvoker(Method method) {
        return this.lifecycleInvokerFactory.createLifecycleInvoker(method);
    }

    @Override
    public ServiceInvoker createServiceInvoker(Method method) {
        return this.serviceInvokerFactory.createInvoker(method);
    }

    @Override
    public ConsumerInvoker createConsumerInvoker(Method method) {
        return this.consumerInvokerFactory.createInvoker(method);
    }
}

