/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.proxy;

import java.net.URI;
import java.util.List;
import org.fabric3.implementation.pojo.spi.proxy.ProxyCreationException;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyService;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyServiceExtension;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Reference;

public class WireProxyServiceImpl
implements WireProxyService {
    private WireProxyServiceExtension extension;

    @Reference(required=false)
    public void setExtensions(List<WireProxyServiceExtension> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        if (extensions.size() == 1) {
            this.extension = extensions.get(0);
        } else {
            if (this.extension != null && !this.extension.isDefault()) {
                return;
            }
            for (WireProxyServiceExtension entry : extensions) {
                if (entry.isDefault()) continue;
                this.extension = entry;
                return;
            }
        }
    }

    @Override
    public <T> ObjectFactory<T> createObjectFactory(Class<T> interfaze, Wire wire, String callbackUri) throws ProxyCreationException {
        this.checkExtension();
        return this.extension.createObjectFactory(interfaze, wire, callbackUri);
    }

    @Override
    public <T> ObjectFactory<T> createCallbackObjectFactory(Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) throws ProxyCreationException {
        this.checkExtension();
        return this.extension.createCallbackObjectFactory(interfaze, multiThreaded, callbackUri, wire);
    }

    @Override
    public <T> ObjectFactory<?> updateCallbackObjectFactory(ObjectFactory<?> factory, Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) throws ProxyCreationException {
        this.checkExtension();
        return this.extension.updateCallbackObjectFactory(factory, interfaze, multiThreaded, callbackUri, wire);
    }

    @Override
    public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
        if (this.extension == null) {
            throw new IllegalArgumentException("Channel proxy service extension not installed");
        }
        return this.extension.cast(target);
    }

    private void checkExtension() throws ProxyCreationException {
        if (this.extension == null) {
            throw new ProxyCreationException("Channel proxy service extension not installed");
        }
    }
}

