/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.objectfactory;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.implementation.pojo.objectfactory.FactoryState;
import org.fabric3.implementation.pojo.objectfactory.MultiplicityObjectFactory;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.fabric3.spi.container.objectfactory.ObjectFactory;

public class MapMultiplicityObjectFactory
implements MultiplicityObjectFactory<Map<?, ?>> {
    private volatile Map<Object, ObjectFactory<?>> factories = new HashMap();
    private Map<Object, ObjectFactory<?>> temporaryFactories;
    private FactoryState state = FactoryState.UPDATED;

    public Map<Object, Object> getInstance() throws ObjectCreationException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<Object, ObjectFactory<?>> entry : this.factories.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getInstance());
        }
        return map;
    }

    @Override
    public void addObjectFactory(ObjectFactory<?> objectFactory, InjectionAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes was null");
        }
        if (attributes.getKey() == null) {
            throw new IllegalArgumentException("Attributes was null");
        }
        if (this.state != FactoryState.UPDATING) {
            throw new IllegalStateException("Factory not in updating state. The method startUpdate() must be called first.");
        }
        this.temporaryFactories.put(attributes.getKey(), objectFactory);
    }

    @Override
    public void clear() {
        this.factories.clear();
    }

    @Override
    public void startUpdate() {
        this.state = FactoryState.UPDATING;
        this.temporaryFactories = new HashMap();
    }

    @Override
    public void endUpdate() {
        if (this.temporaryFactories != null && !this.temporaryFactories.isEmpty()) {
            this.factories = this.temporaryFactories;
            this.temporaryFactories = null;
        }
        this.state = FactoryState.UPDATED;
    }
}

