/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.objectfactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.implementation.pojo.objectfactory.FactoryState;
import org.fabric3.implementation.pojo.objectfactory.MultiplicityObjectFactory;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.ObjectFactory;

public abstract class AbstractCollectionMultiplicityObjectFactory<T extends Collection<ObjectFactory<?>>>
implements MultiplicityObjectFactory<Object> {
    private static final InjectionComparator COMPARATOR = new InjectionComparator();
    protected volatile List<ObjectFactory<?>> factories = new ArrayList();
    private LinkedHashMap<ObjectFactory<?>, InjectionAttributes> temporaryFactories;
    private FactoryState state = FactoryState.UPDATED;

    @Override
    public void addObjectFactory(ObjectFactory<?> objectFactory, InjectionAttributes injectionAttributes) {
        if (this.state != FactoryState.UPDATING) {
            throw new IllegalStateException("Factory not in updating state. The method startUpdate() must be called first.");
        }
        this.temporaryFactories.put(objectFactory, injectionAttributes);
    }

    @Override
    public void clear() {
        this.factories.clear();
    }

    @Override
    public void startUpdate() {
        this.state = FactoryState.UPDATING;
        this.temporaryFactories = new LinkedHashMap();
    }

    @Override
    public void endUpdate() {
        if (this.temporaryFactories != null && !this.temporaryFactories.isEmpty()) {
            this.factories = this.sortTemporaryFactories(this.temporaryFactories);
            this.temporaryFactories = null;
        }
        this.state = FactoryState.UPDATED;
    }

    private List<ObjectFactory<?>> sortTemporaryFactories(LinkedHashMap<ObjectFactory<?>, InjectionAttributes> factories) {
        ArrayList entries = new ArrayList(factories.entrySet());
        Collections.sort(entries, COMPARATOR);
        ArrayList sorted = new ArrayList();
        for (Map.Entry entry : entries) {
            sorted.add((ObjectFactory<?>)entry.getKey());
        }
        return sorted;
    }

    private static class InjectionComparator
    implements Comparator<Map.Entry<ObjectFactory<?>, InjectionAttributes>> {
        private InjectionComparator() {
        }

        @Override
        public int compare(Map.Entry<ObjectFactory<?>, InjectionAttributes> first, Map.Entry<ObjectFactory<?>, InjectionAttributes> second) {
            return first.getValue().getOrder() - second.getValue().getOrder();
        }
    }
}

