/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.manager;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.pojo.manager.ImplementationManager;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ObjectCallbackException;
import org.fabric3.spi.container.component.InstanceDestructionException;
import org.fabric3.spi.container.component.InstanceInitException;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.objectfactory.Injector;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.fabric3.spi.container.objectfactory.ObjectFactory;

public class ImplementationManagerImpl
implements ImplementationManager {
    private URI componentUri;
    private final ObjectFactory<?> constructor;
    private Injectable[] injectables;
    private final Injector<Object>[] injectors;
    private final LifecycleInvoker initInvoker;
    private final LifecycleInvoker destroyInvoker;
    private final ClassLoader cl;
    private final boolean reinjectable;
    private Set<Injector<Object>> updatedInjectors;

    public ImplementationManagerImpl(URI componentUri, ObjectFactory<?> constructor, Injectable[] injectables, Injector<Object>[] injectors, LifecycleInvoker initInvoker, LifecycleInvoker destroyInvoker, boolean reinjectable, ClassLoader cl) {
        this.componentUri = componentUri;
        this.constructor = constructor;
        this.injectables = injectables;
        this.injectors = injectors;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.reinjectable = reinjectable;
        this.cl = cl;
        this.updatedInjectors = reinjectable ? new HashSet<Injector<Object>>() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object newInstance() throws ObjectCreationException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Message message = MessageCache.getMessage();
            Object content = message.getBody();
            Object instance = this.constructor.getInstance();
            if (this.injectors != null) {
                for (Injector<Object> injector : this.injectors) {
                    injector.inject(instance);
                }
            }
            message.setBody(content);
            Object object = instance;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    @Override
    public void start(Object instance) throws InstanceInitException {
        if (this.initInvoker != null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.cl);
                this.initInvoker.invoke(instance);
            }
            catch (ObjectCallbackException e) {
                throw new InstanceInitException("Error initializing instance for: " + this.componentUri, (Throwable)((Object)e));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Object instance) throws InstanceDestructionException {
        block5: {
            try {
                if (this.destroyInvoker == null) break block5;
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.cl);
                    this.destroyInvoker.invoke(instance);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                }
            }
            catch (ObjectCallbackException e) {
                throw new InstanceDestructionException("Error destroying instance for: " + this.componentUri, (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void reinject(Object instance) throws InstanceLifecycleException {
        if (!this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable:" + this.componentUri);
        }
        try {
            for (Injector<Object> injector : this.updatedInjectors) {
                injector.inject(instance);
            }
            this.updatedInjectors.clear();
        }
        catch (ObjectCreationException ex) {
            throw new InstanceLifecycleException("Unable to reinject references on component: " + this.componentUri, (Throwable)ex);
        }
    }

    @Override
    public void updated(Object instance, String referenceName) {
        if (instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable: " + this.componentUri);
        }
        for (int i = 0; i < this.injectables.length; ++i) {
            Injectable attribute = this.injectables[i];
            if (!attribute.getName().equals(referenceName)) continue;
            Injector<Object> injector = this.injectors[i];
            if (instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }

    @Override
    public void removed(Object instance, String referenceName) {
        if (instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable: " + this.componentUri);
        }
        for (int i = 0; i < this.injectables.length; ++i) {
            Injectable attribute = this.injectables[i];
            if (!attribute.getName().equals(referenceName)) continue;
            Injector<Object> injector = this.injectors[i];
            injector.clearObjectFactory();
            if (instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }
}

