/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.implementation.pojo.manager.ImplementationManager;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.manager.ImplementationManagerImpl;
import org.fabric3.implementation.pojo.objectfactory.ArrayMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.ListMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.MapMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.MultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.SetMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.Injector;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

public class ImplementationManagerFactoryImpl
implements ImplementationManagerFactory {
    private static final ObjectFactory<?> NULL_FACTORY = new ObjectFactory<Object>(){

        public Object getInstance() {
            return null;
        }
    };
    private final URI componentUri;
    private final Class<?> implementationClass;
    private final Constructor<?> constructor;
    private final List<Injectable> cdiSources;
    private final Map<InjectionSite, Injectable> postConstruction;
    private final LifecycleInvoker initInvoker;
    private final LifecycleInvoker destroyInvoker;
    private final boolean reinjectable;
    private final ClassLoader cl;
    private ReflectionFactory reflectionFactory;
    private final Map<Injectable, ObjectFactory<?>> factories;

    public ImplementationManagerFactoryImpl(URI componentUri, Constructor<?> constructor, List<Injectable> cdiSources, Map<InjectionSite, Injectable> postConstruction, LifecycleInvoker initInvoker, LifecycleInvoker destroyInvoker, boolean reinjectable, ClassLoader cl, ReflectionFactory reflectionFactory) {
        this.componentUri = componentUri;
        this.reflectionFactory = reflectionFactory;
        this.implementationClass = constructor.getDeclaringClass();
        this.constructor = constructor;
        this.cdiSources = cdiSources;
        this.postConstruction = postConstruction;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.reinjectable = reinjectable;
        this.cl = cl;
        this.factories = new HashMap();
    }

    @Override
    public ImplementationManager createManager() {
        ObjectFactory<?> factory = this.reflectionFactory.createInstantiator(this.constructor, this.getConstructorParameterFactories(this.cdiSources));
        Map<Injectable, Injector<?>> mappings = this.createInjectorMappings();
        Injectable[] attributes = mappings.keySet().toArray(new Injectable[mappings.size()]);
        Injector[] injectors = mappings.values().toArray(new Injector[mappings.size()]);
        return new ImplementationManagerImpl(this.componentUri, factory, attributes, injectors, this.initInvoker, this.destroyInvoker, this.reinjectable, this.cl);
    }

    @Override
    public Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public void startUpdate() {
        for (Map.Entry<Injectable, ObjectFactory<?>> entry : this.factories.entrySet()) {
            Injectable injectable = entry.getKey();
            ObjectFactory<?> factory = entry.getValue();
            if (InjectableType.REFERENCE != injectable.getType() && InjectableType.CALLBACK != injectable.getType() || !(factory instanceof MultiplicityObjectFactory)) continue;
            MultiplicityObjectFactory multiplicityObjectFactory = (MultiplicityObjectFactory)factory;
            multiplicityObjectFactory.startUpdate();
        }
    }

    @Override
    public void endUpdate() {
        for (Map.Entry<Injectable, ObjectFactory<?>> entry : this.factories.entrySet()) {
            Injectable injectable = entry.getKey();
            ObjectFactory<?> factory = entry.getValue();
            if (InjectableType.REFERENCE != injectable.getType() && InjectableType.CALLBACK != injectable.getType() || !(factory instanceof MultiplicityObjectFactory)) continue;
            MultiplicityObjectFactory multiplicityObjectFactory = (MultiplicityObjectFactory)factory;
            multiplicityObjectFactory.endUpdate();
        }
    }

    @Override
    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory) {
        this.setObjectFactory(injectable, objectFactory, InjectionAttributes.EMPTY_ATTRIBUTES);
    }

    @Override
    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory, InjectionAttributes attributes) {
        if (InjectableType.REFERENCE == injectable.getType() || InjectableType.CALLBACK == injectable.getType()) {
            this.setUpdatableFactory(injectable, objectFactory, attributes);
        } else {
            this.factories.put(injectable, objectFactory);
        }
    }

    @Override
    public ObjectFactory<?> getObjectFactory(Injectable injectable) {
        return this.factories.get(injectable);
    }

    @Override
    public void removeObjectFactory(Injectable injectable) {
        this.factories.remove(injectable);
    }

    @Override
    public Class<?> getMemberType(Injectable injectable) {
        InjectionSite site = this.findInjectionSite(injectable);
        if (site == null) {
            throw new AssertionError((Object)("No injection site for " + injectable + " in " + this.implementationClass));
        }
        if (site instanceof FieldInjectionSite) {
            try {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = this.getField(fieldSite.getName());
                return field.getType();
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof MethodInjectionSite) {
            try {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getSignature().getMethod(this.implementationClass);
                return method.getParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof ConstructorInjectionSite) {
            try {
                ConstructorInjectionSite methodSite = (ConstructorInjectionSite)site;
                Constructor method = methodSite.getSignature().getConstructor(this.implementationClass);
                return method.getParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new AssertionError((Object)("Invalid injection site type: " + site.getClass()));
    }

    @Override
    public Type getGenericType(Injectable injectable) {
        InjectionSite site = this.findInjectionSite(injectable);
        if (site == null) {
            throw new AssertionError((Object)("No injection site for " + injectable + " in " + this.implementationClass));
        }
        if (site instanceof FieldInjectionSite) {
            try {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = this.getField(fieldSite.getName());
                return field.getGenericType();
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof MethodInjectionSite) {
            try {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getSignature().getMethod(this.implementationClass);
                return method.getGenericParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof ConstructorInjectionSite) {
            try {
                ConstructorInjectionSite methodSite = (ConstructorInjectionSite)site;
                Constructor method = methodSite.getSignature().getConstructor(this.implementationClass);
                return method.getGenericParameterTypes()[methodSite.getParam()];
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new AssertionError((Object)("Invalid injection site type " + site.getClass()));
    }

    protected ObjectFactory<?>[] getConstructorParameterFactories(List<Injectable> sources) {
        ObjectFactory[] argumentFactories = new ObjectFactory[sources.size()];
        for (int i = 0; i < argumentFactories.length; ++i) {
            Injectable source = sources.get(i);
            ObjectFactory<?> factory = this.factories.get(source);
            if (factory == null) {
                factory = NULL_FACTORY;
            }
            argumentFactories[i] = factory;
        }
        return argumentFactories;
    }

    protected Map<Injectable, Injector<?>> createInjectorMappings() {
        LinkedHashMap injectors = new LinkedHashMap(this.postConstruction.size());
        for (Map.Entry<InjectionSite, Injectable> entry : this.postConstruction.entrySet()) {
            Injector<?> injector;
            InjectionSite site = entry.getKey();
            Injectable attribute = entry.getValue();
            InjectableType type = attribute.getType();
            ObjectFactory<?> factory = this.factories.get(attribute);
            if (factory == null && (type == InjectableType.REFERENCE || type == InjectableType.CALLBACK)) {
                factory = this.createObjectFactory(site.getType());
                this.factories.put(attribute, factory);
            }
            if (factory == null) continue;
            if (site instanceof FieldInjectionSite) {
                try {
                    FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                    Field field = this.getField(fieldSite.getName());
                    injector = this.reflectionFactory.createInjector(field, factory);
                    injectors.put(attribute, injector);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (!(site instanceof MethodInjectionSite)) continue;
            try {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getSignature().getMethod(this.implementationClass);
                injector = this.reflectionFactory.createInjector(method, factory);
                injectors.put(attribute, injector);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        return injectors;
    }

    private void setUpdatableFactory(Injectable injectable, ObjectFactory<?> objectFactory, InjectionAttributes attributes) {
        ObjectFactory<?> factory = this.factories.get(injectable);
        if (factory == null) {
            Class<?> type = this.getMemberType(injectable);
            if (Map.class.equals(type)) {
                MapMultiplicityObjectFactory mapFactory = new MapMultiplicityObjectFactory();
                mapFactory.startUpdate();
                mapFactory.addObjectFactory(objectFactory, attributes);
                this.factories.put(injectable, mapFactory);
            } else if (Set.class.equals(type)) {
                SetMultiplicityObjectFactory setFactory = new SetMultiplicityObjectFactory();
                setFactory.startUpdate();
                setFactory.addObjectFactory(objectFactory, attributes);
                this.factories.put(injectable, setFactory);
            } else if (List.class.equals(type)) {
                ListMultiplicityObjectFactory listFactory = new ListMultiplicityObjectFactory();
                listFactory.startUpdate();
                listFactory.addObjectFactory(objectFactory, attributes);
                this.factories.put(injectable, listFactory);
            } else if (Collection.class.equals(type)) {
                ListMultiplicityObjectFactory listFactory = new ListMultiplicityObjectFactory();
                listFactory.startUpdate();
                listFactory.addObjectFactory(objectFactory, attributes);
                this.factories.put(injectable, listFactory);
            } else if (type.isArray()) {
                ArrayMultiplicityObjectFactory arrayFactory = new ArrayMultiplicityObjectFactory(type.getComponentType());
                arrayFactory.startUpdate();
                arrayFactory.addObjectFactory(objectFactory, attributes);
                this.factories.put(injectable, arrayFactory);
            } else {
                this.factories.put(injectable, objectFactory);
            }
        } else if (factory instanceof MultiplicityObjectFactory) {
            MultiplicityObjectFactory multiplicityObjectFactory = (MultiplicityObjectFactory)factory;
            multiplicityObjectFactory.addObjectFactory(objectFactory, attributes);
        } else {
            this.factories.put(injectable, objectFactory);
        }
    }

    private InjectionSite findInjectionSite(Injectable attribute) {
        for (int i = 0; i < this.cdiSources.size(); ++i) {
            Injectable injectable = this.cdiSources.get(i);
            if (!attribute.equals((Object)injectable)) continue;
            return new ConstructorInjectionSite(this.constructor, i);
        }
        for (Map.Entry<InjectionSite, Injectable> entry : this.postConstruction.entrySet()) {
            if (!entry.getValue().equals((Object)attribute)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Field getField(String name) throws NoSuchFieldException {
        for (Class<?> clazz = this.implementationClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private ObjectFactory<?> createObjectFactory(String referenceType) {
        if ("java.util.Map".equals(referenceType)) {
            return new MapMultiplicityObjectFactory();
        }
        if ("java.util.Set".equals(referenceType)) {
            return new SetMultiplicityObjectFactory();
        }
        if ("java.util.List".equals(referenceType)) {
            return new ListMultiplicityObjectFactory();
        }
        if ("java.util.Collection".equals(referenceType)) {
            return new ListMultiplicityObjectFactory();
        }
        return NULL_FACTORY;
    }
}

