/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.api.model.type.java.Signature;
import org.fabric3.implementation.pojo.manager.ImplementationBuildException;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryImpl;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ImplementationManagerFactoryBuilderImpl
implements ImplementationManagerFactoryBuilder {
    private ReflectionFactory reflectionFactory;
    private ClassLoaderRegistry classLoaderRegistry;

    public ImplementationManagerFactoryBuilderImpl(@Reference ReflectionFactory reflectionFactory, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.reflectionFactory = reflectionFactory;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Override
    public ImplementationManagerFactoryImpl build(ImplementationManagerDefinition definition, ClassLoader cl) throws ImplementationBuildException {
        try {
            URI componentUri = definition.getComponentUri();
            String className = definition.getImplementationClass();
            Class implClass = this.classLoaderRegistry.loadClass(cl, className);
            Constructor ctr = this.getConstructor(implClass, definition.getConstructor());
            Map<InjectionSite, Injectable> injectionSites = definition.getConstruction();
            Injectable[] cdiSources = new Injectable[ctr.getParameterTypes().length];
            for (Map.Entry<InjectionSite, Injectable> entry : injectionSites.entrySet()) {
                InjectionSite site = entry.getKey();
                Injectable injectable = entry.getValue();
                ConstructorInjectionSite constructorSite = (ConstructorInjectionSite)site;
                cdiSources[constructorSite.getParam()] = injectable;
            }
            for (int i = 0; i < cdiSources.length; ++i) {
                if (cdiSources[i] != null) continue;
                String clazz = ctr.getName();
                throw new ImplementationBuildException("No injection value for constructor parameter " + i + " in class " + clazz);
            }
            LifecycleInvoker initInvoker = this.getInitInvoker(definition, implClass);
            LifecycleInvoker destroyInvoker = this.getDestroyInvoker(definition, implClass);
            Map<InjectionSite, Injectable> postConstruction = definition.getPostConstruction();
            List<Injectable> construction = Arrays.asList(cdiSources);
            boolean reinjectable = definition.isReinjectable();
            return new ImplementationManagerFactoryImpl(componentUri, ctr, construction, postConstruction, initInvoker, destroyInvoker, reinjectable, cl, this.reflectionFactory);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            throw new ImplementationBuildException(ex);
        }
    }

    private LifecycleInvoker getInitInvoker(ImplementationManagerDefinition definition, Class<?> implClass) throws NoSuchMethodException, ClassNotFoundException {
        LifecycleInvoker initInvoker = null;
        Method initMethod = this.getMethod(implClass, definition.getInitMethod());
        if (initMethod != null) {
            initInvoker = this.reflectionFactory.createLifecycleInvoker(initMethod);
        }
        return initInvoker;
    }

    private LifecycleInvoker getDestroyInvoker(ImplementationManagerDefinition definition, Class<?> implClass) throws NoSuchMethodException, ClassNotFoundException {
        LifecycleInvoker destroyInvoker = null;
        Method destroyMethod = this.getMethod(implClass, definition.getDestroyMethod());
        if (destroyMethod != null) {
            destroyInvoker = this.reflectionFactory.createLifecycleInvoker(destroyMethod);
        }
        return destroyInvoker;
    }

    private Method getMethod(Class<?> implClass, Signature signature) throws NoSuchMethodException, ClassNotFoundException {
        return signature == null ? null : signature.getMethod(implClass);
    }

    private <T> Constructor<T> getConstructor(Class<T> implClass, Signature signature) throws ClassNotFoundException, NoSuchMethodException {
        Constructor ctr = signature.getConstructor(implClass);
        ctr.setAccessible(true);
        return ctr;
    }
}

