/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.component;

import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.pojo.manager.ImplementationManager;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.objectfactory.ComponentObjectFactory;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ComponentException;
import org.fabric3.spi.container.component.InstanceDestructionException;
import org.fabric3.spi.container.component.InstanceInitException;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.fabric3.spi.container.objectfactory.ObjectFactory;

public abstract class PojoComponent
implements ScopedComponent {
    private URI uri;
    private ImplementationManagerFactory factory;
    private ScopeContainer scopeContainer;
    private QName deployable;
    private boolean eager;
    private ImplementationManager implementationManager;
    private URI classLoaderId;
    private MonitorLevel level = MonitorLevel.INFO;
    private AtomicBoolean recreate = new AtomicBoolean(true);
    private Object cachedInstance;

    public PojoComponent(URI componentId, ImplementationManagerFactory factory, ScopeContainer scopeContainer, QName deployable, boolean eager) {
        this.uri = componentId;
        this.factory = factory;
        this.scopeContainer = scopeContainer;
        this.deployable = deployable;
        this.eager = eager;
    }

    public void start() throws ComponentException {
        this.scopeContainer.register((ScopedComponent)this);
    }

    public void stop() throws ComponentException {
        this.implementationManager = null;
        this.cachedInstance = null;
        this.scopeContainer.unregister((ScopedComponent)this);
    }

    public void startUpdate() {
        this.factory.startUpdate();
    }

    public void endUpdate() {
        this.factory.endUpdate();
    }

    public URI getUri() {
        return this.uri;
    }

    public QName getDeployable() {
        return this.deployable;
    }

    public URI getClassLoaderId() {
        return this.classLoaderId;
    }

    public void setClassLoaderId(URI classLoaderId) {
        this.classLoaderId = classLoaderId;
    }

    public String getName() {
        return this.uri.toString();
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public boolean isEagerInit() {
        return this.eager;
    }

    public Object getInstance() throws InstanceLifecycleException {
        if (this.cachedInstance != null) {
            return this.cachedInstance;
        }
        return this.scopeContainer.getInstance((ScopedComponent)this);
    }

    public void releaseInstance(Object instance) throws InstanceDestructionException {
        this.scopeContainer.releaseInstance((ScopedComponent)this, instance);
    }

    public Object createInstance() throws ObjectCreationException {
        if (this.recreate.getAndSet(false)) {
            this.implementationManager = null;
        }
        Object instance = this.getImplementationManager().newInstance();
        if (Scope.COMPOSITE == this.scopeContainer.getScope()) {
            this.cachedInstance = instance;
        }
        return instance;
    }

    public ObjectFactory<Object> createObjectFactory() {
        return new ComponentObjectFactory((AtomicComponent)this);
    }

    public void startInstance(Object instance) throws InstanceInitException {
        this.getImplementationManager().start(instance);
    }

    public void stopInstance(Object instance) throws InstanceDestructionException {
        this.cachedInstance = null;
        this.getImplementationManager().stop(instance);
    }

    public void reinject(Object instance) throws InstanceLifecycleException {
        this.getImplementationManager().reinject(instance);
    }

    public ScopeContainer getScopeContainer() {
        return this.scopeContainer;
    }

    public Class<?> getImplementationClass() {
        return this.factory.getImplementationClass();
    }

    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory) {
        this.setObjectFactory(injectable, objectFactory, InjectionAttributes.EMPTY_ATTRIBUTES);
    }

    public void setObjectFactory(Injectable injectable, ObjectFactory<?> objectFactory, InjectionAttributes attributes) {
        this.factory.setObjectFactory(injectable, objectFactory, attributes);
        List instances = this.scopeContainer.getActiveInstances((ScopedComponent)this);
        String name = injectable.getName();
        for (Object instance : instances) {
            this.getImplementationManager().updated(instance, name);
        }
        this.recreate.set(true);
    }

    public void removeObjectFactory(Injectable injectable) {
        this.factory.removeObjectFactory(injectable);
        String name = injectable.getName();
        List instances = this.scopeContainer.getActiveInstances((ScopedComponent)this);
        for (Object instance : instances) {
            this.getImplementationManager().removed(instance, name);
        }
        this.recreate.set(true);
    }

    public ObjectFactory<?> getObjectFactory(Injectable injectable) {
        return this.factory.getObjectFactory(injectable);
    }

    public String toString() {
        return "[" + this.uri.toString() + "] in state [" + super.toString() + ']';
    }

    private ImplementationManager getImplementationManager() {
        if (this.implementationManager == null) {
            this.implementationManager = this.factory.createManager();
        }
        return this.implementationManager;
    }
}

