/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.implementation.pojo.builder.KeyInstantiationException;
import org.fabric3.implementation.pojo.provision.PojoWireSourceDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.xsd.XSDSimpleType;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;

public abstract class PojoSourceWireAttacher {
    private static final XSDSimpleType STRING_TYPE = new XSDSimpleType(String.class, new QName("http://www.w3.org/2001/XMLSchema", "string"));
    protected TransformerRegistry transformerRegistry;
    protected ClassLoaderRegistry classLoaderRegistry;

    protected PojoSourceWireAttacher(TransformerRegistry transformerRegistry, ClassLoaderRegistry loaderRegistry) {
        this.transformerRegistry = transformerRegistry;
        this.classLoaderRegistry = loaderRegistry;
    }

    protected Object getKey(PojoWireSourceDefinition sourceDefinition, PhysicalWireTargetDefinition targetDefinition) throws KeyInstantiationException {
        Class keyType;
        if (!sourceDefinition.isKeyed()) {
            return null;
        }
        String key = sourceDefinition.getKey();
        URI targetId = targetDefinition.getClassLoaderId();
        ClassLoader targetClassLoader = this.classLoaderRegistry.getClassLoader(targetId);
        try {
            keyType = this.classLoaderRegistry.loadClass(targetClassLoader, sourceDefinition.getKeyClassName());
        }
        catch (ClassNotFoundException e) {
            throw new KeyInstantiationException("Error loading reference key type for: " + sourceDefinition.getUri(), e);
        }
        if (String.class.equals((Object)keyType)) {
            return key;
        }
        if (Enum.class.isAssignableFrom(keyType)) {
            Class enumClass = keyType;
            return Enum.valueOf(enumClass, key);
        }
        JavaType targetType = new JavaType(keyType);
        return this.createKey((DataType)targetType, key, targetClassLoader);
    }

    private Object createKey(DataType targetType, String value, ClassLoader classLoader) throws KeyInstantiationException {
        try {
            Class type = targetType.getType();
            ArrayList<Class> types = new ArrayList<Class>();
            types.add(type);
            Transformer transformer = this.transformerRegistry.getTransformer((DataType)STRING_TYPE, targetType, types, types);
            if (transformer == null) {
                throw new KeyInstantiationException("No transformer for : " + targetType);
            }
            return transformer.transform((Object)value, classLoader);
        }
        catch (TransformationException e) {
            throw new KeyInstantiationException("Error transforming property", e);
        }
    }
}

