/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.ManagementInfo;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.implementation.pojo.component.PojoComponent;
import org.fabric3.implementation.pojo.component.PojoComponentContext;
import org.fabric3.implementation.pojo.component.PojoRequestContext;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.provision.PojoComponentDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.ComponentBuilder;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.objectfactory.SingletonObjectFactory;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.model.physical.ParamTypes;
import org.fabric3.spi.model.physical.PhysicalPropertyDefinition;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.w3c.dom.Document;

public abstract class PojoComponentBuilder<PCD extends PojoComponentDefinition, C extends Component>
implements ComponentBuilder<PCD, C> {
    protected ClassLoaderRegistry classLoaderRegistry;
    protected IntrospectionHelper helper;
    private HostInfo info;
    private PropertyObjectFactoryBuilder propertyBuilder;
    private ManagementService managementService;

    protected PojoComponentBuilder(ClassLoaderRegistry registry, PropertyObjectFactoryBuilder propertyBuilder, ManagementService managementService, IntrospectionHelper helper, HostInfo info) {
        this.classLoaderRegistry = registry;
        this.propertyBuilder = propertyBuilder;
        this.managementService = managementService;
        this.helper = helper;
        this.info = info;
    }

    protected void createPropertyFactories(PCD definition, ImplementationManagerFactory factory) throws ContainerException {
        List propertyDefinitions = definition.getPropertyDefinitions();
        TypeMapping typeMapping = new TypeMapping();
        this.helper.resolveTypeParameters(factory.getImplementationClass(), typeMapping);
        for (PhysicalPropertyDefinition propertyDefinition : propertyDefinitions) {
            String name = propertyDefinition.getName();
            Injectable source = new Injectable(InjectableType.PROPERTY, name);
            if (propertyDefinition.getInstanceValue() != null) {
                SingletonObjectFactory objectFactory = new SingletonObjectFactory(propertyDefinition.getInstanceValue());
                factory.setObjectFactory(source, (ObjectFactory<?>)objectFactory);
                continue;
            }
            Document value = propertyDefinition.getValue();
            Type type = factory.getGenericType(source);
            DataType dataType = this.getDataType(type, typeMapping);
            ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(definition.getClassLoaderId());
            boolean many = propertyDefinition.isMany();
            ObjectFactory<?> objectFactory = this.propertyBuilder.createFactory(name, dataType, value, many, classLoader);
            factory.setObjectFactory(source, objectFactory);
        }
    }

    protected void export(PojoComponentDefinition definition, ClassLoader classLoader, AtomicComponent component) throws ContainerException {
        if (definition.isManaged()) {
            ManagementInfo info = definition.getManagementInfo();
            ObjectFactory objectFactory = component.createObjectFactory();
            try {
                URI uri = definition.getComponentUri();
                this.managementService.export(uri, info, objectFactory, classLoader);
            }
            catch (ManagementException e) {
                throw new ContainerException((Throwable)e);
            }
        }
    }

    protected void dispose(PojoComponentDefinition definition) throws ContainerException {
        if (definition.isManaged()) {
            ManagementInfo info = definition.getManagementInfo();
            try {
                URI uri = definition.getComponentUri();
                this.managementService.remove(uri, info);
            }
            catch (ManagementException e) {
                throw new ContainerException((Throwable)e);
            }
        }
    }

    protected void buildContexts(PojoComponent component, ImplementationManagerFactory factory) {
        PojoRequestContext requestContext = new PojoRequestContext();
        SingletonObjectFactory requestFactory = new SingletonObjectFactory((Object)requestContext);
        factory.setObjectFactory(Injectable.OASIS_REQUEST_CONTEXT, (ObjectFactory<?>)requestFactory);
        PojoComponentContext componentContext = new PojoComponentContext(component, requestContext, this.info);
        SingletonObjectFactory componentFactory = new SingletonObjectFactory((Object)componentContext);
        factory.setObjectFactory(Injectable.OASIS_COMPONENT_CONTEXT, (ObjectFactory<?>)componentFactory);
    }

    private DataType getDataType(Type type, TypeMapping typeMapping) {
        if (type instanceof Class) {
            Class nonGenericType = (Class)type;
            if (nonGenericType.isPrimitive()) {
                nonGenericType = (Class)ParamTypes.PRIMITIVE_TO_OBJECT.get(nonGenericType);
            }
            return new JavaType(nonGenericType);
        }
        JavaTypeInfo info = this.helper.createTypeInfo(type, typeMapping);
        return new JavaGenericType(info);
    }
}

