/*
 * Fabric3
 * Copyright (c) 2009-2015 Metaform Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Portions originally based on Apache Tuscany 2007
 * licensed under the Apache 2.0 license.
 */
package org.fabric3.jpa.api;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/**
 * Resolves a Fabric3 transaction manager for Hibernate.
 */
@EagerInit
public final class F3TransactionManagerLookup extends AbstractJtaPlatform {
    private static final long serialVersionUID = 422525777190048472L;
    private static TransactionManager TM;

    @Reference
    public void setTransactionManager(TransactionManager transactionManager) {
        F3TransactionManagerLookup.TM = transactionManager;
    }

    protected TransactionManager locateTransactionManager() {
        return TM;
    }

    protected UserTransaction locateUserTransaction() {
        return null;
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }
}
