/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.emf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.datasource.spi.DataSourceRegistry;
import org.fabric3.jpa.runtime.emf.Fabric3PersistenceUnitInfo;
import org.fabric3.jpa.runtime.emf.PersistenceContextParser;
import org.fabric3.jpa.runtime.emf.PersistenceUnitException;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.Reference;

public class PersistenceContextParserImpl
implements PersistenceContextParser {
    private XMLInputFactory factory;
    private DataSourceRegistry registry;

    public PersistenceContextParserImpl(@Reference DataSourceRegistry registry, @Reference XMLFactory xmlFactory) {
        this.registry = registry;
        this.factory = xmlFactory.newInputFactoryInstance();
    }

    @Override
    public List<PersistenceUnitInfo> parse(ClassLoader classLoader) throws PersistenceUnitException {
        Enumeration<URL> urls;
        try {
            urls = classLoader.getResources("META-INF/persistence.xml");
        }
        catch (IOException e) {
            throw new PersistenceUnitException(e);
        }
        if (urls == null) {
            throw new PersistenceUnitException("Persistence context (persistence.xml) not found in /META-INF");
        }
        ArrayList<PersistenceUnitInfo> infos = new ArrayList<PersistenceUnitInfo>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URL rootUrl = this.getRootJarUrl(url);
            InputStream stream = null;
            XMLStreamReader reader = null;
            try {
                stream = url.openStream();
                reader = this.factory.createXMLStreamReader(stream);
                reader.nextTag();
                PersistenceUnitInfo info = null;
                String version = "2.0";
                boolean parse = true;
                block12: while (parse) {
                    int event = reader.next();
                    switch (event) {
                        case 1: {
                            if ("persistence".equals(reader.getName().getLocalPart())) {
                                String versionAttr = reader.getAttributeValue(null, "version");
                                if (versionAttr == null) continue block12;
                                version = versionAttr;
                                break;
                            }
                            if (!"persistence-unit".equals(reader.getName().getLocalPart())) break;
                            info = this.parsePersistenceUnit(reader, classLoader, rootUrl, version);
                            infos.add(info);
                            break;
                        }
                        case 2: {
                            if (!"persistence-unit".equals(reader.getName().getLocalPart()) || info != null) break;
                            throw new PersistenceUnitException("Invalid persistence.xml found in :" + rootUrl);
                        }
                        case 8: {
                            parse = false;
                        }
                    }
                }
                this.close(stream, reader);
            }
            catch (IOException | XMLStreamException e) {
                try {
                    throw new PersistenceUnitException(e);
                }
                catch (Throwable throwable) {
                    this.close(stream, reader);
                    throw throwable;
                }
            }
        }
        return infos;
    }

    private URL getRootJarUrl(URL url) throws PersistenceUnitException {
        try {
            String protocol = url.getProtocol();
            if ("jar".equals(protocol)) {
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                return jarURLConnection.getJarFileURL();
            }
            if ("file".equals(protocol)) {
                String path = url.getPath();
                return new File(path).getParentFile().getParentFile().toURI().toURL();
            }
            if ("zip".equals(protocol)) {
                String path = url.getPath();
                String rootJarUrl = path.substring(0, path.lastIndexOf("META-INF") - 2);
                rootJarUrl = "file:" + rootJarUrl;
                return new URL(rootJarUrl);
            }
            throw new PersistenceUnitException("Unknown protocol: " + protocol);
        }
        catch (IOException e) {
            throw new PersistenceUnitException(e);
        }
    }

    private PersistenceUnitInfo parsePersistenceUnit(XMLStreamReader reader, ClassLoader classLoader, URL rootUrl, String version) throws XMLStreamException, PersistenceUnitException, MalformedURLException {
        String name = reader.getAttributeValue(null, "name");
        String trxAttr = reader.getAttributeValue(null, "transaction-type");
        PersistenceUnitTransactionType trxType = "JTA".equals(trxAttr) ? PersistenceUnitTransactionType.JTA : PersistenceUnitTransactionType.RESOURCE_LOCAL;
        Fabric3PersistenceUnitInfo info = new Fabric3PersistenceUnitInfo(name);
        info.setPersistenceXMLSchemaVersion(version);
        info.setTrxType(trxType);
        info.setClassLoader(classLoader);
        info.setRootUrl(rootUrl);
        while (true) {
            int event = reader.nextTag();
            switch (event) {
                case 1: {
                    SharedCacheMode mode;
                    if ("jta-data-source".equals(reader.getName().getLocalPart())) {
                        DataSource dataSource = this.getDataSource(reader);
                        info.setJtaDataSource(dataSource);
                        break;
                    }
                    if ("non-jta-data-source".equals(reader.getName().getLocalPart())) {
                        DataSource dataSource = this.getDataSource(reader);
                        info.setNonJtaDataSource(dataSource);
                        break;
                    }
                    if ("provider".equals(reader.getName().getLocalPart())) {
                        String className = reader.getElementText();
                        info.setPersistenceProviderClassName(className);
                        break;
                    }
                    if ("class".equals(reader.getName().getLocalPart())) {
                        String className = reader.getElementText();
                        info.addManagedClass(className);
                        break;
                    }
                    if ("properties".equals(reader.getName().getLocalPart())) {
                        this.parseProperties(info, reader);
                        break;
                    }
                    if ("mapping-file".equals(reader.getName().getLocalPart())) {
                        String file = reader.getElementText();
                        info.addMappingFile(file);
                        break;
                    }
                    if ("jar-file".equals(reader.getName().getLocalPart())) {
                        URL file = new File(reader.getElementText()).toURI().toURL();
                        info.addJarFileUrl(file);
                        break;
                    }
                    if ("exclude-unlisted-classes".equals(reader.getName().getLocalPart())) {
                        boolean exclude = Boolean.parseBoolean(reader.getElementText());
                        info.setExcludeUnlistedClasses(exclude);
                        break;
                    }
                    if ("shared-cache-mode".equals(reader.getName().getLocalPart())) {
                        String value = reader.getElementText();
                        try {
                            mode = SharedCacheMode.valueOf((String)value);
                            info.setSharedCacheMode(mode);
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new PersistenceUnitException("Illegal shared cache mode: " + value);
                        }
                    }
                    if (!"validation-mode".equals(reader.getName().getLocalPart())) break;
                    String value = reader.getElementText();
                    try {
                        mode = ValidationMode.valueOf((String)value);
                        info.setValidationMode((ValidationMode)mode);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new PersistenceUnitException("Illegal validation mode: " + value);
                    }
                }
                case 2: {
                    if (!"persistence-unit".equals(reader.getName().getLocalPart())) break;
                    return info;
                }
            }
        }
    }

    private DataSource getDataSource(XMLStreamReader reader) throws PersistenceUnitException {
        try {
            String dataSourceName = reader.getElementText();
            DataSource dataSource = this.registry.getDataSource(dataSourceName);
            if (dataSource == null) {
                throw new PersistenceUnitException("DataSource not found: " + dataSourceName);
            }
            return dataSource;
        }
        catch (XMLStreamException e) {
            throw new PersistenceUnitException(e);
        }
    }

    private void parseProperties(Fabric3PersistenceUnitInfo info, XMLStreamReader reader) throws XMLStreamException {
        while (true) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!"property".equals(reader.getName().getLocalPart())) break;
                    String name = reader.getAttributeValue(null, "name");
                    String value = reader.getAttributeValue(null, "value");
                    info.addProperty(name, value);
                    break;
                }
                case 2: {
                    if (!"properties".equals(reader.getName().getLocalPart())) break;
                    return;
                }
            }
        }
    }

    private void close(InputStream stream, XMLStreamReader reader) {
        if (stream != null) {
            try {
                stream.close();
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException | XMLStreamException e) {
                e.printStackTrace();
            }
        }
    }
}

