/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.emf;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.fabric3.spi.classloader.MultiParentClassLoader;

public class Fabric3PersistenceUnitInfo
implements PersistenceUnitInfo {
    private String unitName;
    private URL rootUrl;
    private ClassLoader classLoader;
    private String persistenceProviderClassName;
    private boolean exclude;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private List<URL> jarUrls = new ArrayList<URL>();
    private List<String> managedClasses = new ArrayList<String>();
    private List<String> mappingFiles = new ArrayList<String>();
    private Properties properties = new Properties();
    private PersistenceUnitTransactionType trxType;
    private String version = "2.0";
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode validationMode = ValidationMode.AUTO;

    public Fabric3PersistenceUnitInfo(String unitName) {
        this.unitName = unitName;
    }

    public String getPersistenceUnitName() {
        return this.unitName;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.rootUrl;
    }

    public void addTransformer(ClassTransformer classTransformer) {
    }

    public void setExcludeUnlistedClasses(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean excludeUnlistedClasses() {
        return this.exclude;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addJarFileUrl(URL url) {
        this.jarUrls.add(url);
    }

    public List<URL> getJarFileUrls() {
        return this.jarUrls;
    }

    public void setRootUrl(URL rootUrl) {
        this.rootUrl = rootUrl;
    }

    public void setJtaDataSource(DataSource dataSource) {
        this.jtaDataSource = dataSource;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void addManagedClass(String name) {
        this.managedClasses.add(name);
    }

    public List<String> getManagedClassNames() {
        return this.managedClasses;
    }

    public void addMappingFile(String name) {
        this.mappingFiles.add(name);
    }

    public List<String> getMappingFileNames() {
        return this.mappingFiles;
    }

    public ClassLoader getNewTempClassLoader() {
        if (!(this.classLoader instanceof MultiParentClassLoader)) {
            return null;
        }
        MultiParentClassLoader original = (MultiParentClassLoader)this.classLoader;
        MultiParentClassLoader newClassLoader = new MultiParentClassLoader(URI.create("f3-temp"), original.getParent());
        for (ClassLoader parent : original.getParents()) {
            newClassLoader.addParent(parent);
        }
        for (URL url : original.getURLs()) {
            newClassLoader.addURL(url);
        }
        return newClassLoader;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setTrxType(PersistenceUnitTransactionType trxType) {
        this.trxType = trxType;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.trxType;
    }

    public void addProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.version;
    }

    public void setPersistenceXMLSchemaVersion(String version) {
        this.version = version;
    }
}

