/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.generator;

import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.model.HibernateSessionResourceReference;
import org.fabric3.jpa.override.OverrideRegistry;
import org.fabric3.jpa.provision.SessionWireTargetDefinition;
import org.fabric3.spi.domain.generator.resource.ResourceReferenceGenerator;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SessionResourceReferenceGenerator
implements ResourceReferenceGenerator<HibernateSessionResourceReference> {
    private OverrideRegistry registry;

    public SessionResourceReferenceGenerator(@Reference OverrideRegistry registry) {
        this.registry = registry;
    }

    public SessionWireTargetDefinition generateWireTarget(LogicalResourceReference<HibernateSessionResourceReference> logicalResourceReference) {
        HibernateSessionResourceReference resource = (HibernateSessionResourceReference)logicalResourceReference.getDefinition();
        String unitName = resource.getUnitName();
        SessionWireTargetDefinition definition = new SessionWireTargetDefinition(unitName);
        PersistenceOverrides overrides = this.registry.resolve(unitName);
        if (overrides != null) {
            definition.setOverrides(overrides);
        }
        boolean multiThreaded = resource.isMultiThreaded();
        definition.setOptimizable(true);
        definition.setMultiThreaded(multiThreaded);
        return definition;
    }
}

