/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jpa.runtime.emf;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.fabric3.api.host.Names;
import org.fabric3.jpa.api.EntityManagerFactoryResolver;
import org.fabric3.jpa.api.F3TransactionManagerLookup;
import org.fabric3.jpa.api.JpaResolutionException;
import org.fabric3.jpa.api.PersistenceOverrides;
import org.fabric3.jpa.runtime.emf.EntityManagerFactoryCache;
import org.fabric3.jpa.runtime.emf.PersistenceContextParser;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.oasisopen.sca.annotation.Reference;

public class CachingEntityManagerFactoryResolver
implements EntityManagerFactoryResolver {
    private static final String HIBERNATE_LOOKUP = "hibernate.transaction.jta.platform";
    private PersistenceContextParser parser;
    private EntityManagerFactoryCache cache;

    public CachingEntityManagerFactoryResolver(@Reference PersistenceContextParser parser, @Reference EntityManagerFactoryCache cache) {
        this.parser = parser;
        this.cache = cache;
    }

    @Override
    public synchronized EntityManagerFactory resolve(String unitName, PersistenceOverrides overrides, ClassLoader classLoader) throws JpaResolutionException {
        EntityManagerFactory resolvedEmf = this.cache.get(unitName);
        if (resolvedEmf != null) {
            return resolvedEmf;
        }
        EntityManagerFactory factory = this.createEntityManagerFactory(overrides, classLoader);
        URI key = classLoader instanceof MultiParentClassLoader ? ((MultiParentClassLoader)classLoader).getName() : Names.HOST_CONTRIBUTION;
        this.cache.put(key, unitName, factory);
        return factory;
    }

    private EntityManagerFactory createEntityManagerFactory(PersistenceOverrides overrides, ClassLoader classLoader) throws JpaResolutionException {
        List<PersistenceUnitInfo> infos = this.parser.parse(classLoader);
        String unitName = overrides.getUnitName();
        for (PersistenceUnitInfo info : infos) {
            if (!unitName.equals(info.getPersistenceUnitName())) continue;
            Properties unitProperties = info.getProperties();
            unitProperties.setProperty(HIBERNATE_LOOKUP, F3TransactionManagerLookup.class.getName());
            unitProperties.putAll(overrides.getProperties());
            PersistenceUnitInfoDescriptor descriptor = new PersistenceUnitInfoDescriptor(info);
            EntityManagerFactoryBuilderImpl builder = new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)descriptor, Collections.emptyMap(), classLoader);
            return builder.build();
        }
        throw new JpaResolutionException("Persistence unit not defined for: " + unitName);
    }
}

